// Compiled by ClojureScript 1.11.60 {:optimizations :none}
goog.provide('same.diff');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('same.ish');
goog.require('same.platform');
/**
 * If `a` is an array, convert to a vector so it prints nicely.
 */
same.diff.un_array = (function same$diff$un_array(a){
if(same.platform.is_array_QMARK_.call(null,a)){
return cljs.core.vec.call(null,a);
} else {
return a;
}
});
same.diff.result_vec = (function same$diff$result_vec(var_args){
var args__5775__auto__ = [];
var len__5769__auto___13599 = arguments.length;
var i__5770__auto___13600 = (0);
while(true){
if((i__5770__auto___13600 < len__5769__auto___13599)){
args__5775__auto__.push((arguments[i__5770__auto___13600]));

var G__13601 = (i__5770__auto___13600 + (1));
i__5770__auto___13600 = G__13601;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return same.diff.result_vec.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(same.diff.result_vec.cljs$core$IFn$_invoke$arity$variadic = (function (n,res,next){
if(cljs.core.empty_QMARK_.call(null,next)){
return res;
} else {
return cljs.core.into.call(null,cljs.core.into.call(null,(function (){var or__5045__auto__ = res;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.take.call(null,(n - cljs.core.count.call(null,res)),cljs.core.repeat.call(null,null))),next);
}
}));

(same.diff.result_vec.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(same.diff.result_vec.cljs$lang$applyTo = (function (seq13596){
var G__13597 = cljs.core.first.call(null,seq13596);
var seq13596__$1 = cljs.core.next.call(null,seq13596);
var G__13598 = cljs.core.first.call(null,seq13596__$1);
var seq13596__$2 = cljs.core.next.call(null,seq13596__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__13597,G__13598,seq13596__$2);
}));


/**
 * Protocol for generating diffs of any type.
 * @interface
 */
same.diff.Diff = function(){};

var same$diff$Diff$diff$dyn_13602 = (function (this$,that){
var x__5393__auto__ = (((this$ == null))?null:this$);
var m__5394__auto__ = (same.diff.diff[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,this$,that);
} else {
var m__5392__auto__ = (same.diff.diff["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,this$,that);
} else {
throw cljs.core.missing_protocol.call(null,"Diff.diff",this$);
}
}
});
/**
 * Returns the diff of two values, in the same format as `clojure.data/diff`,
 *  i.e. a vector of 3 elements: `[parts-only-in-this parts-only-in-that parts-in-both]`
 */
same.diff.diff = (function same$diff$diff(this$,that){
if((((!((this$ == null)))) && ((!((this$.same$diff$Diff$diff$arity$2 == null)))))){
return this$.same$diff$Diff$diff$arity$2(this$,that);
} else {
return same$diff$Diff$diff$dyn_13602.call(null,this$,that);
}
});

/**
 * Diff of sequential types, by comparing element-wise.
 */
same.diff.diff_seq = (function same$diff$diff_seq(this$,that){
var l = null;
var r = null;
var c = null;
var n = (0);
var left = this$;
var right = that;
while(true){
if(((cljs.core.empty_QMARK_.call(null,left)) || (cljs.core.empty_QMARK_.call(null,right)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,same.diff.result_vec,n,l,left),cljs.core.apply.call(null,same.diff.result_vec,n,r,right),c], null);
} else {
var vec__13612 = left;
var seq__13613 = cljs.core.seq.call(null,vec__13612);
var first__13614 = cljs.core.first.call(null,seq__13613);
var seq__13613__$1 = cljs.core.next.call(null,seq__13613);
var l0 = first__13614;
var lm = seq__13613__$1;
var vec__13615 = right;
var seq__13616 = cljs.core.seq.call(null,vec__13615);
var first__13617 = cljs.core.first.call(null,seq__13616);
var seq__13616__$1 = cljs.core.next.call(null,seq__13616);
var r0 = first__13617;
var rm = seq__13616__$1;
if(cljs.core.truth_(same.ish.ish.call(null,l0,r0))){
var G__13621 = l;
var G__13622 = r;
var G__13623 = same.diff.result_vec.call(null,n,c,r0);
var G__13624 = (n + (1));
var G__13625 = lm;
var G__13626 = rm;
l = G__13621;
r = G__13622;
c = G__13623;
n = G__13624;
left = G__13625;
right = G__13626;
continue;
} else {
var vec__13618 = same.diff.diff.call(null,l0,r0);
var dl = cljs.core.nth.call(null,vec__13618,(0),null);
var dr = cljs.core.nth.call(null,vec__13618,(1),null);
var dc = cljs.core.nth.call(null,vec__13618,(2),null);
var G__13627 = same.diff.result_vec.call(null,n,l,dl);
var G__13628 = same.diff.result_vec.call(null,n,r,dr);
var G__13629 = (((dc == null))?c:same.diff.result_vec.call(null,n,c,dc));
var G__13630 = (n + (1));
var G__13631 = lm;
var G__13632 = rm;
l = G__13627;
r = G__13628;
c = G__13629;
n = G__13630;
left = G__13631;
right = G__13632;
continue;
}
}
break;
}
});
same.diff.update_common_keys = (function same$diff$update_common_keys(acc,lmap,rmap,keys){
return cljs.core.reduce.call(null,(function (m,k){
var vec__13633 = same.diff.diff.call(null,cljs.core.get.call(null,lmap,k),cljs.core.get.call(null,rmap,k));
var dl = cljs.core.nth.call(null,vec__13633,(0),null);
var dr = cljs.core.nth.call(null,vec__13633,(1),null);
var dc = cljs.core.nth.call(null,vec__13633,(2),null);
var G__13636 = m;
var G__13636__$1 = (((((!((dl == null)))) || ((!((dr == null))))))?cljs.core.assoc_in.call(null,G__13636,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"l","l",1395893423),k], null),dl):G__13636);
var G__13636__$2 = (((((!((dl == null)))) || ((!((dr == null))))))?cljs.core.assoc_in.call(null,G__13636__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"r","r",-471384190),k], null),dr):G__13636__$1);
if((!((dc == null)))){
return cljs.core.assoc_in.call(null,G__13636__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"c","c",-1763192079),k], null),dc);
} else {
return G__13636__$2;
}
}),acc,keys);
});
same.diff.update_float_keys = (function same$diff$update_float_keys(acc,lmap,rmap,lkeys,rkeys){
var a = acc;
var lk = lkeys;
var rk = rkeys;
while(true){
if(((cljs.core.empty_QMARK_.call(null,lk)) && (cljs.core.empty_QMARK_.call(null,rk)))){
return a;
} else {
if(cljs.core.empty_QMARK_.call(null,lk)){
return cljs.core.reduce.call(null,((function (a,lk,rk){
return (function (p1__13637_SHARP_,p2__13638_SHARP_){
return cljs.core.assoc_in.call(null,p1__13637_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"r","r",-471384190),p2__13638_SHARP_], null),cljs.core.get.call(null,rmap,p2__13638_SHARP_));
});})(a,lk,rk))
,a,rk);
} else {
if(cljs.core.empty_QMARK_.call(null,rk)){
return cljs.core.reduce.call(null,((function (a,lk,rk){
return (function (p1__13639_SHARP_,p2__13640_SHARP_){
return cljs.core.assoc_in.call(null,p1__13639_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"l","l",1395893423),p2__13640_SHARP_], null),cljs.core.get.call(null,lmap,p2__13640_SHARP_));
});})(a,lk,rk))
,a,lk);
} else {
var vec__13641 = lk;
var seq__13642 = cljs.core.seq.call(null,vec__13641);
var first__13643 = cljs.core.first.call(null,seq__13642);
var seq__13642__$1 = cljs.core.next.call(null,seq__13642);
var lk0 = first__13643;
var lkr = seq__13642__$1;
var vec__13644 = rk;
var seq__13645 = cljs.core.seq.call(null,vec__13644);
var first__13646 = cljs.core.first.call(null,seq__13645);
var seq__13645__$1 = cljs.core.next.call(null,seq__13645);
var rk0 = first__13646;
var rkr = seq__13645__$1;
var lv = cljs.core.get.call(null,lmap,lk0);
var rv = cljs.core.get.call(null,rmap,rk0);
if(cljs.core.truth_(same.ish.ish.call(null,lk0,rk0))){
var vec__13647 = same.diff.diff.call(null,lv,rv);
var dl = cljs.core.nth.call(null,vec__13647,(0),null);
var dr = cljs.core.nth.call(null,vec__13647,(1),null);
var dc = cljs.core.nth.call(null,vec__13647,(2),null);
var acc__$1 = (function (){var G__13650 = a;
var G__13650__$1 = (((((!((dl == null)))) || ((!((dr == null))))))?cljs.core.assoc_in.call(null,G__13650,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"l","l",1395893423),lk0], null),dl):G__13650);
var G__13650__$2 = (((((!((dl == null)))) || ((!((dr == null))))))?cljs.core.assoc_in.call(null,G__13650__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"r","r",-471384190),rk0], null),dr):G__13650__$1);
if((!((dc == null)))){
return cljs.core.assoc_in.call(null,G__13650__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"c","c",-1763192079),rk0], null),dc);
} else {
return G__13650__$2;
}
})();
var G__13651 = acc__$1;
var G__13652 = lkr;
var G__13653 = rkr;
a = G__13651;
lk = G__13652;
rk = G__13653;
continue;
} else {
if((lk0 < rk0)){
var G__13654 = cljs.core.assoc_in.call(null,a,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"l","l",1395893423),lk0], null),lv);
var G__13655 = lkr;
var G__13656 = rk;
a = G__13654;
lk = G__13655;
rk = G__13656;
continue;
} else {
var G__13657 = cljs.core.assoc_in.call(null,a,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"r","r",-471384190),rk0], null),rv);
var G__13658 = lk;
var G__13659 = rkr;
a = G__13657;
lk = G__13658;
rk = G__13659;
continue;

}
}

}
}
}
break;
}
});
(same.diff.Diff["null"] = true);

(same.diff.diff["null"] = (function (_this,that){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,that,null], null);
}));

(same.diff.Diff["number"] = true);

(same.diff.diff["number"] = (function (this$,that){
if(cljs.core.truth_(same.ish.ish.call(null,this$,that))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null,that], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$,that,null], null);
}
}));

(same.diff.Diff["boolean"] = true);

(same.diff.diff["boolean"] = (function (this$,that){
if(cljs.core.truth_(same.ish.ish.call(null,this$,that))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null,that], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$,that,null], null);
}
}));

(same.diff.Diff["string"] = true);

(same.diff.diff["string"] = (function (this$,that){
if(cljs.core.truth_(same.ish.ish.call(null,this$,that))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null,that], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$,that,null], null);
}
}));

(same.diff.Diff["array"] = true);

(same.diff.diff["array"] = (function (this$,that){
if(same.platform.is_array_QMARK_.call(null,that)){
return same.diff.diff_seq.call(null,this$,that);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [same.diff.un_array.call(null,this$),that,null], null);
}
}));

(same.diff.Diff["object"] = true);

(same.diff.diff["object"] = (function (this$,that){
if(cljs.core.truth_(same.ish.ish.call(null,this$,that))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null,same.diff.un_array.call(null,that)], null);
} else {
if(((cljs.core.sequential_QMARK_.call(null,this$)) && (cljs.core.sequential_QMARK_.call(null,that)))){
return same.diff.diff_seq.call(null,this$,that);
} else {
if(((cljs.core.map_QMARK_.call(null,this$)) && (cljs.core.map_QMARK_.call(null,that)))){
var vec__13660 = same.ish.split_floats.call(null,cljs.core.keys.call(null,this$));
var this_floats = cljs.core.nth.call(null,vec__13660,(0),null);
var this_rest = cljs.core.nth.call(null,vec__13660,(1),null);
var vec__13663 = same.ish.split_floats.call(null,cljs.core.keys.call(null,that));
var that_floats = cljs.core.nth.call(null,vec__13663,(0),null);
var that_rest = cljs.core.nth.call(null,vec__13663,(1),null);
var extract = cljs.core.juxt.call(null,new cljs.core.Keyword(null,"l","l",1395893423),new cljs.core.Keyword(null,"r","r",-471384190),new cljs.core.Keyword(null,"c","c",-1763192079));
return cljs.core.mapv.call(null,cljs.core.not_empty,extract.call(null,same.diff.update_float_keys.call(null,same.diff.update_common_keys.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"l","l",1395893423),cljs.core.select_keys.call(null,this$,clojure.set.difference.call(null,this_rest,that_rest)),new cljs.core.Keyword(null,"r","r",-471384190),cljs.core.select_keys.call(null,that,clojure.set.difference.call(null,that_rest,this_rest)),new cljs.core.Keyword(null,"c","c",-1763192079),cljs.core.PersistentArrayMap.EMPTY], null),this$,that,clojure.set.intersection.call(null,this_rest,that_rest)),this$,that,cljs.core.sort.call(null,this_floats),cljs.core.sort.call(null,that_floats))));
} else {
if(((cljs.core.set_QMARK_.call(null,this$)) && (cljs.core.set_QMARK_.call(null,that)))){
var vec__13666 = same.ish.split_floats.call(null,this$);
var this_floats = cljs.core.nth.call(null,vec__13666,(0),null);
var this_rest = cljs.core.nth.call(null,vec__13666,(1),null);
var vec__13669 = same.ish.split_floats.call(null,that);
var that_floats = cljs.core.nth.call(null,vec__13669,(0),null);
var that_rest = cljs.core.nth.call(null,vec__13669,(1),null);
var l = clojure.set.difference.call(null,this_rest,that_rest);
var r = clojure.set.difference.call(null,that_rest,this_rest);
var c = clojure.set.intersection.call(null,this_rest,that_rest);
var left = cljs.core.sort.call(null,this_floats);
var right = cljs.core.sort.call(null,that_floats);
while(true){
if(((cljs.core.empty_QMARK_.call(null,left)) || (cljs.core.empty_QMARK_.call(null,right)))){
return cljs.core.mapv.call(null,cljs.core.not_empty,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.into.call(null,l,left),cljs.core.into.call(null,r,right),c], null));
} else {
var vec__13678 = left;
var seq__13679 = cljs.core.seq.call(null,vec__13678);
var first__13680 = cljs.core.first.call(null,seq__13679);
var seq__13679__$1 = cljs.core.next.call(null,seq__13679);
var vl = first__13680;
var rl = seq__13679__$1;
var vec__13681 = right;
var seq__13682 = cljs.core.seq.call(null,vec__13681);
var first__13683 = cljs.core.first.call(null,seq__13682);
var seq__13682__$1 = cljs.core.next.call(null,seq__13682);
var vr = first__13683;
var rr = seq__13682__$1;
if(cljs.core.truth_(same.ish.ish.call(null,vl,vr))){
var G__13684 = l;
var G__13685 = r;
var G__13686 = cljs.core.conj.call(null,c,vr);
var G__13687 = rl;
var G__13688 = rr;
l = G__13684;
r = G__13685;
c = G__13686;
left = G__13687;
right = G__13688;
continue;
} else {
if((vl < vr)){
var G__13689 = cljs.core.conj.call(null,l,vl);
var G__13690 = r;
var G__13691 = c;
var G__13692 = rl;
var G__13693 = right;
l = G__13689;
r = G__13690;
c = G__13691;
left = G__13692;
right = G__13693;
continue;
} else {
var G__13694 = l;
var G__13695 = cljs.core.conj.call(null,r,vr);
var G__13696 = c;
var G__13697 = left;
var G__13698 = rr;
l = G__13694;
r = G__13695;
c = G__13696;
left = G__13697;
right = G__13698;
continue;

}
}
}
break;
}
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$,same.diff.un_array.call(null,that),null], null);

}
}
}
}
}));

//# sourceMappingURL=diff.js.map
