// Notes:
// Swift has conditional compilation but I assume that we can skip that.
// The reason is because conditional compilation in Swift must completely
// surround blocks of code that are self-contained and syntactically valid.

grammar Swift;
options {superClass=hotspots_x_ray.languages.InterruptibleParser;}

import SwiftSharedRulesLexer;

translationunit
:
	expression* EOF
;

expression : function_declaration
           | class_block
           | init_declaration
           | top_level_block_statement
           | anything;

anything : ~(LeftBrace | RightBrace);

class_block: (CLASS | STRUCT | EXTENSION | ENUM) class_name anything*? LeftBrace expression*? RightBrace;
class_name: ID;

top_level_block_statement : LeftBrace (top_level_block_statement | anything)*? RightBrace;

function_declaration : FUNCTION function_name function_scope;

function_name: ~LeftParen+;

init_declaration : INIT LeftParen function_scope;

function_scope: function_signature LeftBrace function_body RightBrace;

function_signature: ~LeftBrace+;

function_body : function_body_statement*?;

function_body_statement : block_statement
                        | anything;

block_statement : LeftBrace function_body_statement*? RightBrace;
