grammar ObjectiveCSharedRulesParser;

import ObjectiveCSharedRulesLexer;

anything : ~(LeftBrace | RightBrace);

objective_c_expression : objective_c_method_definition
                       | pre_proc_top_level_start
                       | block_statement
                       | any_objective_c_statement;

any_objective_c_statement : ~IMPLEMENTATION_END;

// We just want to get rid of the symbol following the #ifdef so that it's not part of a possible subsequent function.
pre_proc_top_level_start : (PRE_PROC_IF | PRE_PROC_IFDEF | PRE_PROC_IFNDEF) pre_proc_top_level_condition;

// We use a different rule on the top-level since we need to parse more carefully (and significantly slower) in
// order to not consume function signatures that may follow immediately after.
pre_proc_top_level_condition : '!'?  ('1' | '0' | ID)
                             | LeftParen pre_proc_top_level_condition RightParen
                             | 'defined' LeftParen pre_proc_top_level_condition RightParen;

specta_bdd_test_context: DESCRIBE LeftParen unit_test_name COMMA CARRET LeftBrace specta_unit_test_body*  RightBrace RightParen SEMICOLON;
specta_unit_test_body: kiwi_unit_test_context | kiwi_unit_test | block_statement | any_statement;

kiwi_unit_test_context: CONTEXT LeftParen unit_test_name COMMA CARRET LeftBrace kiwi_unit_test_context_body*  RightBrace RightParen SEMICOLON;
kiwi_unit_test_context_body: kiwi_unit_test | block_statement | any_statement;
kiwi_unit_test: IT LeftParen unit_test_name COMMA CARRET LeftBrace kiwi_unit_test_body RightBrace RightParen SEMICOLON;
kiwi_unit_test_body: function_body;
unit_test_name: (VERBATIM_STRING | LITERAL);

objective_c_method_definition : ('-' | '+') LeftParen ~RightParen+ RightParen (obj_c_selectors | function_name)
                                ~LeftBrace* LeftBrace function_body RightBrace;

obj_c_selectors: obj_c_selector+;
obj_c_selector: obj_c_selector_name COLON obj_c_method_type obj_c_method_arg_name;
obj_c_selector_name: ID;
obj_c_method_type: LeftParen obj_c_method_type_type RightParen;
obj_c_method_type_type: ~(RightParen)*?;
obj_c_method_arg_name: ID;

cpp_function_definition : 'explicit'? function_name LeftParen function_definition_params_list? RightParen ':' member_init_list LeftBrace function_body RightBrace
                         | 'explicit'? function_name LeftParen function_definition_params_list? RightParen LeftBrace function_body RightBrace
                         | function_type_signature function_name LeftParen function_definition_params_list? RightParen function_modifier* LeftBrace function_body RightBrace;

function_modifier : 'const' | 'override';

function_type_signature : ~(LeftBrace | RightBrace | LeftParen | RightParen |
                            PRE_PROC_IFDEF | PRE_PROC_IF | PRE_PROC_IFNDEF |
                            PRE_PROC_ENDIF | PRE_PROC_ELSE | SEMICOLON | TYPEDEF)+?;
function_name : '~'? (OPERATOR | ID | SCOPED_NAME);

member_init_list : member_init_list_param
                 | member_init_list ',' member_init_list_param;
member_init_list_param : member_init_name LeftParen member_init_value? RightParen;
member_init_name : ID;
member_init_value : (ID | SCOPED_NAME | INT | DEREFERENCED_OBJECT)
                  | (ID | SCOPED_NAME | DEREFERENCED_OBJECT) LeftParen function_param*? RightParen // init with function call
                    (',' member_init_value)*
                  | ~(LeftParen | RightParen)+?;

function_definition_params_list : function_param
                                | function_definition_params_list ',' function_param
                                | function_param+
                                ;

function_param: (ID | SCOPED_NAME | INT | DEREFERENCED_OBJECT) LeftParen function_param RightParen // a macro wrapping a parameter
               | ~('=' | LeftBrace)+? '=' ~LeftParen*? LeftParen RightParen // NOTE: note generic enough - could have arguments!
               | ~(LeftParen | RightParen)+?;
function_body : function_body_statement*?;

function_body_statement : pre_proc_block
                        | block_statement
                        | any_statement;

block_statement_body: kiwi_unit_test_context
                    | kiwi_unit_test
                    | function_body_statement;

block_statement : LeftBrace block_statement_body*? RightBrace;

pre_proc_block : (PRE_PROC_IF | PRE_PROC_IFDEF | PRE_PROC_IFNDEF) pre_proc_condition? pre_proc_block_statement*? (PRE_PROC_ELSE | PRE_PROC_ENDIF);
pre_proc_block_statement : (PRE_PROC_IF | PRE_PROC_IFDEF | PRE_PROC_IFNDEF) pre_proc_condition? pre_proc_block_statement*? PRE_PROC_ENDIF
                         | ~(PRE_PROC_ENDIF | PRE_PROC_IF | PRE_PROC_IFDEF | PRE_PROC_IFNDEF);
pre_proc_condition : ('!' | '1' | '0' | ID);

any_statement : ~(LeftBrace | RightBrace | NAMESPACE | PRE_PROC_IF | PRE_PROC_IFDEF | PRE_PROC_IFNDEF);

