lexer grammar ObjectiveCSharedRulesLexer;

// Pre-processor directives: since we already handle top-level blocks we're free to
// ignore multi-line macros, etc. All that we need es to identify conditional compilation
// directives _inside_ functions. We need to parse them away because they may lead to
// unbalanced curly braces otherwise.

SHARP : '#';

PRE_PROC_IF : SHARP 'if';
PRE_PROC_IFDEF : SHARP 'ifdef';
PRE_PROC_IFNDEF : SHARP 'ifndef';

PRE_PROC_ELSE : SHARP 'else';

PRE_PROC_ENDIF: SHARP 'endif';

fragment VERBATIM_ESCAPE : '""';
VERBATIM_STRING : '@' '"' ( VERBATIM_ESCAPE | ~('"'))* '"';

fragment ESCAPED : '\\\\' | '\\"';
LITERAL : '"' ( ESCAPED | ~('\n'|'\r') )*? '"';

PRE_PROC_DEFINE : SHARP 'define' ((('\\"' | ~('\\' | '\r' | '\n'))+? '\\' '\r'? '\n'))+? (~[\\]*? '\r'? '\n') -> skip;

PRE_PROC_SKIP_DEFINE : SHARP 'define' ~('\r' | '\n' | '\\')+?  '\r'? '\n' -> skip;
INCLUDE : SHARP 'include' ~('\r' | '\n')+? '\r'? '\n' -> skip;
PRAGMA : SHARP 'pragma' ~('\r' | '\n')+? '\r'? '\n' -> skip;
UNDEF : SHARP 'undef'  ~('\r' | '\n')+? '\r'? '\n' -> skip;
IMPORT : SHARP 'import' ~('\r' | '\n')+? '\r'? '\n' -> skip;

EXTERN_C : 'extern "C"' ~('{')*? LeftBrace;

LITERAL_CHAR : '\'' . '\'' -> skip;

IMPLEMENTATION_START : '@implementation';
IMPLEMENTATION_END : '@end';

CLASS : 'class';
STRUCT : 'struct';
NAMESPACE : 'namespace';
TYPEDEF : 'typedef';

COLON: ':';

// BDD framework tokens
IT: 'it';
CONTEXT: 'context'; // Kiwi
DESCRIBE: 'describe'; // Spectra
CARRET: '^';

NOEXCEPT: 'noexcept';
THROW: 'throw';

// Needed for method arguments
UNSIGNED: 'unsigned';

AMP: '&';
STAR: '*';

LeftParen : '(';
RightParen: ')';

LeftBrace : '{';
RightBrace : '}';

SEMICOLON : ';';
COMMA: ',';

Whitespace : [ \t]+ -> skip;

BlockComment: '/*' .*? '*/' -> skip;
LineComment: '//' ~[\r\n]* -> skip;

NEWLINE : '\r'? '\n' -> skip;

ID : [a-zA-Z_][a-zA-Z0-9_]*;

SCOPER : '::';
SCOPED_NAME : SCOPER? ID (SCOPER ID)+;

OPERATOR : 'operator()' | ('operator' ~('(' | ')' | '{' | '}')+);

DEREFERENCE : '->' | '.';
DEREFERENCED_OBJECT : (ID | SCOPED_NAME)  (DEREFERENCE (ID | SCOPED_NAME))+;

INT : [0-9]+;

ANY_CHAR : .; // Put this lexer rule last to give it the lowest precedence
