grammar KotlinNestedComplexity;

import KotlinSharedRulesLexer;

method
:
	expression* EOF
;

expression : complexity
           | block_expression
           | anything;

complexity: if_clause
          | else_clause
          | when_expr
          | for_loop
          | while_loop
          | do_while_loop;

block_expression: LeftBrace expression*? RightBrace;

anything: ~(LeftBrace | RightBrace);

if_clause: IF some_condition complexity_body;
else_clause: ELSE complexity_body;

when_expr: WHEN some_condition? complexity_body;

for_loop: FOR some_condition complexity_body;

while_loop: WHILE some_condition complexity_body;
do_while_loop: DO complexity_body WHILE some_condition;

multi_line_conditional_expression: LeftBrace expression*? RightBrace;
plain_line: ~(LeftBrace | '->');

complexity_body: multi_line_conditional_expression | plain_line;

some_condition: LeftParen conditions+? RightParen;
conditions : conditional_operator
           | ~(LeftParen | RightParen | SEMICOLON)
           | LeftParen conditions*? RightParen;

conditional_operator: AND | OR;