grammar GoMethodArguments;

import GoSharedRulesLexer;

singlefunctionscope
:
	expression* EOF
;

expression : function_declaration
           | top_level_block_statement
           | anything;

anything : ~(LeftBrace | RightBrace);

top_level_block_statement : LeftBrace (top_level_block_statement | anything)*? RightBrace;

function_declaration : FUNCTION receiver? function_name type_parameters? function_scope;
// Since we don't use the information inside the type parameter list, we completely ignore it.
type_parameters: LeftBracket .+? RightBracket;

function_name: ID;

function_scope: LeftParen function_definition_params_list? RightParen return_type LeftBrace function_body RightBrace;

return_type: ~LeftBrace*?;

function_definition_params_list : function_param_definition ','?
                                | function_definition_params_list ',' function_param_definition ','?
                                ;
// NOTE: Go supports consecutive parameters. That is, if some paramters are of the same type, the
// type can be written once. I.e. price int, no int can be written as price, no int
// We resolve it in the visitor that operates on the resulting parse tree.

function_param_definition: function_param interface_modifier?;
function_param: plain_type
              | reference_type
              | array_type
              | variadic_type
              | generic_type
              | function_param_type
              | unnamed_param_type // this is actualy Go's consecutive parameters, resolved later in the visitor.
              | empty_interface_param_type;

interface_modifier: LeftBrace ~RightBrace*? RightBrace;
array_type: ID '[' ~(']')*? ']' param_type;
reference_type: ID '*' param_type;
plain_type: ID param_type;
variadic_type: ID '...' param_type;
generic_type: ID generic_type_spec;
generic_type_spec: ID '[' ID ']' (ID | EMPTY_INTERFACE);
function_param_type: ID function_param_type_signature function_param_return_spec? ; // a func(a, b int) int
empty_interface_param_type: ID empty_interface; // func x(i interface{})
empty_interface: EMPTY_INTERFACE;

param_type: param_type_part_name
           | param_type '.' param_type_part_name;
param_type_part_name: ID;

unnamed_param_type: ID;
function_param_type_signature: FUNCTION LeftParen function_definition_params_list? RightParen;
function_param_return_spec: ID | function_param_type_signature;

receiver: LeftParen~(',' | RightParen)+? RightParen;

function_body : function_body_statement*?;

function_body_statement : block_statement
                        | anything;

block_statement : LeftBrace function_body_statement*? RightBrace;


