(ns codescene.features.reports.four-factor-pdf
  (:require
   [codescene.features.reports.common.styling :as styling]
   [codescene.features.reports.code-health.alerts :as alerts]
   [codescene.features.reports.code-health.trend-graph :as trend-graph]
   [codescene.features.reports.code-health.code-health-overview :as code-health-overview]
   [codescene.features.reports.code-health.code-health-scores :as code-health-scores]
   [codescene.features.reports.code-health.period-stats-summary :as period-stats-summary]
   [codescene.features.reports.portfolio.all-projects-summary :as all-projects-summary]
   [codescene.features.reports.code-health.pr-stats :as pr-stats]
   [codescene.features.reports.common.pdf-elements :as pdf-elements]
   [codescene.features.reports.common.glossary :as glossary]
   [codescene.features.reports.code-health.pdf-elements :as ch-pdf-elements]
   [codescene.features.reports.portfolio.pdf-elements :as p-pdf-elements]
   [codescene.features.reports.portfolio.four-factor-info :as four-factor-info]
   [codescene.features.reports.portfolio.status-overview :as status-overview]
   [codescene.features.reports.portfolio.project-cards :as project-cards]))

(defn code-health-report
  "Generate pdf-data for generation of 4f code health report"
  [{:keys [name _file-summary dashboard
           period-renderable-trends year-renderable-trends
           this-period-statistics previous-period-statistics
           beginning end] :as data}
   {:keys [img-dir] :as options}
   date-now]
  (let [header-row-1 (format "Project name: %s" (styling/string->cutoff-string name 30))
        right-header (pdf-elements/right-header header-row-1 date-now)
        title-page (ch-pdf-elements/title-page-contents data name img-dir date-now)]
    (concat
     [(pdf-elements/with-optional-metadata options)]
     (pdf-elements/title-page options title-page)
     ;; Content page creates the gray background, the nice header and so on
     (pdf-elements/content-page
      options right-header
      (ch-pdf-elements/page1
       options
       [(code-health-overview/pdf-element data name options)
        (ch-pdf-elements/all-factors period-renderable-trends options)
        (code-health-scores/pdf-element period-renderable-trends year-renderable-trends options)
        (alerts/pdf-element dashboard options)]))
     (pdf-elements/content-page
      options right-header
      (ch-pdf-elements/page2
       options beginning end
       [(period-stats-summary/pdf-element this-period-statistics previous-period-statistics options)
        (pr-stats/pdf-element this-period-statistics options)
        (trend-graph/pdf-element period-renderable-trends options beginning end)
        (ch-pdf-elements/code-red options)]))
     (pdf-elements/content-page
      options right-header
      (glossary/pdf-element options)))))

(defn portfolio-report
  "Generate pdf-data for generation of 4f portfolio"
  [{:keys [projects account-info]} {:keys [img-dir] :as options} date-now]
  (let [title-page (p-pdf-elements/title-page-contents account-info date-now img-dir)
        right-header (pdf-elements/right-header "Software Portfolio Overview" date-now)]
    (concat
     ;; non optional metadata :O)
     [(pdf-elements/with-optional-metadata options)]
     (pdf-elements/title-page options title-page)
     (pdf-elements/content-page options right-header
                                (p-pdf-elements/page-1 options
                                                       (four-factor-info/pdf-element options)
                                                       [(all-projects-summary/pdf-element projects account-info options)
                                                        (status-overview/pdf-element projects account-info options)]))
     (apply concat                                          ;; to flatten the list of lists of project card pdf elements
            (for [page-of-projs (partition-all 6 projects)]
              (pdf-elements/content-page options right-header
                                         (p-pdf-elements/page-2 options
                                                                (project-cards/pdf-elements page-of-projs options)))))
     (pdf-elements/content-page options right-header (glossary/pdf-element options)))))



(comment                                                    ;; explore projects data
 (declare projects)
 ;; number of projects:
 (count projects)                                           ; 17

 ;; total LOC -> reduce + will have to suffice, seems excessive to resolve the
 ;; duplicated stuff
 (reduce + (keep (comp :total-lines-of-code :last-analysis) projects)) ; 7565065

 ;; active authors, use /active-authors underlying function and pass it in
 )
