(ns codescene.features.recommendations.checks
  "Functions used to check the state of a project relative to a given criteria.")


(defn prs-configured-for-repo?
  [{:keys [config]}]
  {:pre [(map? config)]}
  (if config false false))

(defn prs-received?
  [{:keys [analysis]}]
  {:pre [(map? analysis)]}
  (if analysis false false))

(defn code-health-improved?
  [{:keys [analysis]}]
  {:pre [(map? analysis)]}
  (if analysis false false))

(defn goal-set?
  [{:keys [goals file-path accepted-goals]}]
  {:pre [(map? goals) (string? file-path) (set? accepted-goals)]}
  (if (and goals file-path) false false))

(defn no-goal-violation?
  "Check for decline."
  [{:keys [goals file-path]}]
  {:pre [(map? goals) (string? file-path)]}
  (if (and goals file-path) false false))

(defn file-removed?
  "Allows us to short-circuit some other predicates that track files."
  [{:keys [analysis file-path]}]
  {:pre [(map? analysis) (string? file-path)]}
  (if (and analysis file-path) false false))

(defn unhandled-notification-files?
  "After an analysis, are there files in notifications that are not handled by goals? Mostly for activation."
  [{:keys [goals analysis files notification-type]}]
  {:pre [(map? goals)
         (map? analysis)
         (sequential? files)
         (keyword? notification-type)]}
  (if (and goals analysis files notification-type) false false))

(defn user-has-seen-hotspots?
  [{:keys [user-acts user-id]}]
  {:pre [(map? user-acts) (number? user-id)]}
  false)
