(ns codescene.features.pm-data.clickup.cache
  "Wraps some fetcher fns to make them cacheable"
  (:require [codescene.features.pm-data.clickup.fetcher :as f]
            [codescene.features.pm-data.cache :as cache]))

(def ^:private cached-data-version 1)

(defn- fetch-tasks-key-fn
  [_ _ list-ids]
  [list-ids cached-data-version])

(def ^:private fetch-tasks-cacheable (cache/make-cacheable f/fetch-tasks))
(cache/memo #'fetch-tasks-cacheable fetch-tasks-key-fn)

(defn fetch-tasks
  [since api-client list-ids]
  (cache/combine-with-cache fetch-tasks-cacheable fetch-tasks-key-fn
                            since api-client list-ids))

(comment
  (def api-client (codescene.features.pm-data.click-up.api/clickup-auth (System/getenv "CLICKUP_TOKEN")))

  (let [list-ids ["901505265065"]
        since (evolutionary-metrics.trends.dates/string->date "2023-07-01")]
    (codescene.cache.core/with-file-cache "." "." :pm-data
      (fetch-tasks since api-client list-ids)))
  )

