(ns codescene.features.delta.code-health.pr-check
  (:require [clojure.java.jdbc :as jdbc]
            [codescene.features.util.maps :refer [->db-keys]]
            [codescene.features.delta.code-health.ch-config :as ch]
            [codescene.features.delta.integration.integration-db :as integration-db]
            [codescene.features.project.core :as project.core]
            [codescene.features.project.pr-integration :as pi]))

(defn repos-with-delta-other-projects
  "Finds all repos used in the project and returns repo URLs of
  repos that are used in other Code Health delta analysis enabled projects."
  [tx project-id]
  (keep :repo_url (integration-db/elsewhere-ch-enabled-repos tx {:project_id project-id})))

(def qg-preset-desc
  (integration-db/preset-desc
    "pr-quality-gates"
    #(assoc % :qg-preset "global")
    {:qg-preset "minimal"}))

(defn check-enabled?
  ([tx project-id]
   (true? (:ch-enabled? (integration-db/get-core-config tx project-id))))
  ([config-set]
   (-> config-set :metadata :ch-enabled? true?)))

(defn onprem-integration-page-data
  [tx project-id]
  (integration-db/get-config tx project-id ch/ch-on-prem-api-properties))

(defn onprem-api-config
  [tx project-id]
  (integration-db/get-config tx project-id ch/ch-on-prem-api-properties))

(defn cloud-project-config
  [tx project-id provider-id]
  (or (integration-db/get-config tx project-id ch/ch-cloud-project-config-properties)
      (integration-db/empty-config project-id ch/ch-cloud-project-config-properties provider-id)))

(defn disable-integration
  [db-spec ProjectConfiguration]
  (jdbc/with-db-transaction
    [tx db-spec]
    (pi/with-ci-integration-updates
      tx
      ProjectConfiguration
      (fn [] (integration-db/update-core-configuration
               tx
               {:project-id (project.core/-id ProjectConfiguration) :ch-enabled? false})
        nil)
      (fn [ret action e] [(ex-message e)]))))

(defn ch-enabled-lookup [tx filter]
  (into {}
        (map (juxt :project_id :ch_enabled))
        (integration-db/get-all-core-configs tx (->db-keys filter))))