(ns codescene.features.components.analytics
  (:require [clojure.spec.alpha :as s]
            [codescene.features.spec.auth :as auth]))

(defprotocol AnalyticsComponent
  (-send-user-event [this user event properties]))

(s/fdef send-user-event
  :args (s/cat :this some?
               :user ::auth/user
               :event keyword?
               :properties map?)
  :ret any?)
(defn send-user-event
  "Send an analytics event"
  [this user event properties]
  (-send-user-event this user event properties))
