(ns codescene.features.api.routes.me
  (:require [codescene.features.api.core :as api-core]
            [codescene.features.api.privileges :as api-privileges]
            [codescene.features.components.auth :as auth]
            [codescene.features.util.api :as api-utils]
            [compojure.api.sweet :refer [GET context]]
            [medley.core :as m]))

(defn- get-me
  "Returns the authenticated user's (token's) ID, some of the privileges and it will
  indicate if project is accessible if project ID is provided via query parameter.

  This can be used by REST API users to see their own permissions and capabilities and
  it is also used by devtools portal to see permission of the cloud user of the token."
  [system request]
  (let [auth-comp (api-core/api-auth system)
        {:keys [user-id account-id identity admin? privileges]} (auth/user auth-comp request)]
    (-> {:admin?     admin?
         :refactor?  (auth/has-refactoring-access? auth-comp request)
         :privileges privileges}
        (merge (when-let [project-id (-> request :params :project-id)]
                 {:project?  (auth/has-project-access? auth-comp request project-id)
                  :devtools? (auth/has-devtools-access? auth-comp request project-id)}))
        (m/assoc-some :username identity)
        (m/assoc-some :user-id user-id)
        (m/assoc-some :account-id account-id))))

(defn sub-routes
  [system]
  (context "/me" []
    :middleware [#(api-core/wrap-authorize-any system % #{api-privileges/restapi-read api-privileges/cli-access})]
    (GET "/" request
      (api-utils/ok (get-me system request)))))
