// @flow

import $ from 'jquery';
import d3 from 'd3';

import * as Architectural from 'codescene-ui/src/configuration/architectural-components/architectural-components.jsx';

function directoryColor(node, activeAspect) {
  const color = (() => {
    if ('hotspots' === activeAspect.id) {
      return d3.scale
        .linear()
        .domain([-1, 8])
        .range(['hsl(185,60%,99%)', 'hsl(187,40%,70%)'])
        .interpolate(d3.interpolateHcl);
    } else if ('codeAge' === activeAspect.id) {
      return d3.scale
        .linear()
        .domain([0, 10])
        .range(['#eeeeee', '#aaaaaa'])
        .interpolate(d3.interpolateRgb);
    } else {
      return null;
    }
  })();

  return color ? [color(node.depth), 1] : ['white', 0];
}

function fileColor(node, activeAspect) {
  if ('hotspots' === activeAspect.id) {
    return ['darkred', node.revs / activeAspect.maxValue];
  } else if ('codeAge' === activeAspect.id) {
    const ageColor = d3.scale
      .quantize()
      .range(['#0570b0', '#74a9cf', '#bdc9e1', '#f1eef6'])
      .domain([0, activeAspect.maxValue]);
    return [ageColor(node.age), 1];
  } else {
    return ['white', 0];
  }
}

function renderFileDetails() {
  return new Promise(function () {
    // no op
  });
}

// type InitParams = {
//   projectId: number,
//   latestAnalysisId?: number,
//   enableArchitecturalMatchPriority?: boolean,
//   container: $,
// };

export function init({
  projectId,
  latestAnalysisId,
  enableArchitecturalMatchPriority,
  container,
}) {
  const helpText = $('.foldable');

  $('#expand-architectural-component-editing-text').click((ev) => {
    ev.preventDefault();

    let vis = helpText.find(':visible');
    let button = $(ev.target);

    if (vis.length > 0) {
      helpText.hide();
      button.addClass('fa-plus-circle');
      button.removeClass('fa-minus-circle');
    } else {
      helpText.show();
      button.removeClass('fa-plus-circle');
      button.addClass('fa-minus-circle');
    }
  });

  const submitButton = $('button#architectural-components-submit');
  const maybeSystemMapUrl = latestAnalysisId
    ? window.baseUrl +
      projectId +
      '/analyses/' +
      latestAnalysisId +
      '/systemmap.json'
    : false;

  Architectural.init({
    mountPoint: container,
    submitButton,
    systemMapUrl: maybeSystemMapUrl,
    componentsUrl:
      window.baseUrl +
      'projects/' +
      projectId +
      '/architectural-components/components.json',
    enableArchitecturalMatchPriority,
    systemOpts: {
      showSidebar: true,
      renderFileDetails: renderFileDetails,
      directoryColor: directoryColor,
      fileColor: fileColor,
      projectId,
      enableArchitecturalMatchPriority,
    },
  });
}
