// @flow
import $ from 'jquery';

// Safe to expose here since we do server side authorization and you need to be
// an Administrator.
function deleteCustomReport(id, name) {
  if (!confirm('Are you sure you want to delete the custom report ' + name + '?')) {
    return false;
  }

  $.ajax({type: 'DELETE',
    url: window.baseUrl + 'configuration/custom-reports/delete/' + id,
    success: function() {
      $('tr[data-custom-report-id=' + id + ']').remove();
    },
    error: function() {
      alert('Failed to delete ' + name);
    }
  });
  return true;
}

export function initList() {
  $('.custom-report-delete').on('click', function () {
    var $button = $(this);
    var customReportId = $button.data('custom-report-id');
    var customReportName = $button.data('custom-report-name');
    deleteCustomReport(customReportId, customReportName);
  });

  $('.custom-report-edit').on('click', function () {
    var $button = $(this);
    var customReportId = $button.data('custom-report-id');
    window.location.href = window.baseUrl + 'configuration/custom-reports/edit/' + customReportId;
  });
}

export function init(report_type, selected_fields) {

  if(selected_fields.length > 0) {
    selected_fields.split(',').forEach(item => {
      var selector = '.' + report_type + '-fields.' + item;
      $(selector).attr('checked', true);
    });
  }

  $('input[name="report_type"]').click(function(){
    var type = $('input[name="report_type"]:checked').val();
    $('#file-level-fields-toggleable').toggle(type === 'file-level');
    $('#architectural-level-fields-toggleable').toggle(type === 'architectural-level');
    if(type === 'file-level') {
      $('.architectural-level-fields').prop('checked', false);
      $('.architectural-all').prop('checked', false);
    }
    if(type === 'architectural-level') {
      $('.file-level-fields').prop('checked', false);
      $('.file-all').prop('checked', false);
    }
  });

  $('input[name="file-all"]').click(function(){
    $('.file-level-fields').prop('checked', this.checked);
  });

  $('input[name="architectural-all"]').click(function(){
    $('.architectural-level-fields').prop('checked', this.checked);
  });

  $('.btn-cancel').on('click', function () {
    window.location.href = window.baseUrl + 'configuration/custom-reports';
  });
}
