public class ComplexMethod {
	public void postItem(Item a) throws ValidationException {
		if (a.isNew()) {
			postNew(a);
		} else {
			postUpdate(a);
		}
	}

	private void postNew(Item a) throws ValidationException {
		a.ensureComplete();
		post(a);
	}

	private void postUpdate(Item a) throws ValidationException {
		a.ensureValidUpdate();
		post(a);
	}
}
