grammar RubyNestedComplexity;
options {superClass=hotspots_x_ray.languages.InterruptibleParser;}
import RubySharedRulesLexer;

method
 :
 	expression* EOF
 ;

 expression : bdd_blocks
            | complexity_block
            | block_statement
            | anything;

anything : ~(END | IF | ELSEIF |  UNTIL | UNLESS | WHILE | DO | FOR | CASE | BEGIN);

// BDD tests: these need to be matched separately as they will add to the complexity values otherwise
//
bdd_blocks: bdd_description
          | bdd_context
          | bdd_named_test;

bdd_description: DESCRIBE ~(DO | CRLF)+ DO bdd_description_body END;

bdd_description_body: expression*?;

bdd_context: CONTEXT bdd_context_name DO bdd_actual_test_body END;
bdd_context_name: LITERAL;

bdd_named_test: IT bdd_test_name DO bdd_actual_test_body END;
bdd_test_name: LITERAL;

bdd_actual_test_body: expression*?;

// Complexity
//

block_statement : module_block_statement
                | begin_block_statement
                | single_line_complexity_block;

complexity_block: while_do
                | begin_while
                | begin_until
                //| for_each_do
                | until_do
                | if_block
                | crlf (UNLESS | WHILE | DO | FOR | CASE | BEGIN) expression+ END
                | do_block_statement;

if_block: crlf IF single_line_condition
               (expression | elseif_block)+
           END;

elseif_block: crlf ELSEIF single_line_condition expression+;

while_do: crlf WHILE leading_condition expression+ END;
until_do: crlf UNTIL leading_condition expression+ END;
begin_while: crlf BEGIN expression+? END WHILE terminating_condition;
begin_until: crlf BEGIN expression+? END UNTIL terminating_condition;
//for_each_do: DOT_EACH DO local_arg_spec expression+? END;
//local_arg_spec: '|' ~('|')*? '|';
leading_condition: (conditional_operator | ~(DO | CRLF))+? DO;
terminating_condition: (conditional_operator | anything)+;

conditional_operator: LOGICAL_OPERATORS;

single_line_complexity_block: unless_single_line_statement
                            | if_single_line_statement
                            | while_single_line_statement;

module_block_statement : MODULE ID crlf expression+ END;
do_block_statement    : ~(DEF | END | IF | UNTIL | UNLESS | WHILE | FOR | CASE | BEGIN | MODULE | CRLF)+? DO expression+? END;
begin_block_statement : ~(CRLF)+? BEGIN expression+? END;

// NOTE: just lookahead to crlf - do NOT consume it since we'll then miss a block_statement that follows immediately after.
//
// This grammar catches Ruby guard clauses such as:
// return nil if order.outstanding_payments?
// return nil unless parameter == true #<-- guard clause
unless_single_line_statement : ~(DEF | END | IF | WHILE | DO | FOR | CASE | BEGIN | MODULE | CRLF)+? UNLESS single_line_condition;
if_single_line_statement     :  ~(DEF | END | UNLESS | WHILE | DO | FOR | CASE | BEGIN | MODULE | CRLF)+? IF single_line_condition;
while_single_line_statement  :  ~(DEF | END | UNLESS | DO | FOR | CASE | BEGIN | MODULE | CRLF)+? WHILE single_line_condition;

single_line_condition: (conditional_operator | ~(CRLF | THEN | END))+;

crlf : CRLF;
