grammar CodeOwners;

translationunit
:
	expression* EOF
;

expression : ownership_spec
           | anything;


ownership_spec: ownership_row;

ownership_row: git_attributes_spec  // specified in .gitattributes: some/path/to/file2.pl owners= my@email.com,another@owner.com
             | code_ownership_spec; // e.g. GitHub, GitLab, BitBucket: *.js @octocat @github/js

code_ownership_spec: file_pattern Whitespace ws_separated_owners;

git_attributes_spec: file_pattern Whitespace ownership_assignment Whitespace? comma_separated_owners;

ownership_assignment: OWNERS ASSIGN;

file_pattern: FilePattern;

comma_separated_owners: specific_owner
                      | comma_separated_owners ',' specific_owner;

ws_separated_owners: specific_owner
                   | ws_separated_owners Whitespace specific_owner;

email_owner: EmailOwnerStyle;

specific_owner: GitHubOwnerStyle | ESCAPED_OWNER | email_owner;

anything: .;

fragment ESCAPED : '\\\\' | '\\"';
ESCAPED_OWNER : '@"' ( ESCAPED | ~('\n'|'\r') )*? '"'; // a user with whitespace in their handle

LineComment: '#' ~[\r\n]* -> skip;

NEWLINE : '\r'? '\n';

OWNERS: 'owners';
ASSIGN: '=';

GitHubOwnerStyle: '@' ~[ \t\r\n,]+;

EmailOwnerStyle: ~[ \t\r\n,=]+ '@' ~[ \t\r\n,]+;

FilePattern: ([a-zA-Z0-9_\-*/.] | '\\#' | '\\ ')+;

Whitespace : [ \t]+;

ANY_CHAR : .; // Put this lexer rule last to give it the lowest precedence
