grammar ApexConsecutiveAssertions;

singlefunctionscope
:
	expression* EOF
;

expression : assertion_blocks
           | .;

assertion_blocks: assertion_statement+;

assertion_statement: (ASSERT_START | QUALIFIED_ASSERT_START) ~(SEMICOLON)+ SEMICOLON;

QUALIFIED_ASSERT_START: 'System.assert';
ASSERT_START: 'assert';
SEMICOLON : ';';

fragment ESCAPED : '\\\\' | '\\\'';
LITERAL : '\'' ( ESCAPED | ~('\''))*? '\'';

LITERAL_CHAR : '\'' . '\'' -> skip;

Whitespace : [ \t]+ -> skip;

BlockComment: '/*' .*? '*/' -> skip;
LineComment: '//' ~[\r\n]* -> skip;

NEWLINE : '\r'? '\n' -> skip;

ANY_CHAR: .;