(ns codescene.features.time-series.code-coverage
  (:require
   [clj-time.coerce :as tcoerce]
   [clj-time.core :as t]
   [clj-time.format :as f]
   [clojure.java.io :as io]
   [codescene.analysis.paths :as paths]
   [codescene.features.time-series.core :as tsc]
   [codescene.features.time-series.time-series-db :as time-series-db]
   [codescene.util.json :as json]))


(defn- summary-file
  [analysis-results-path]
  (io/file analysis-results-path paths/code-coverage-summary-json))


(defn append-analysis-result-file
  [db-spec project-id timestamp analysis-results-path]
  (when-let [data (json/read-when-exists (summary-file analysis-results-path))]
    (let [json-for-db (assoc data :timestamp (tsc/to-json-date timestamp))]
      (time-series-db/insert-entry
       db-spec
       "code-coverage"
       {:project-id  project-id
        :timestamp timestamp
        :payload json-for-db}))))


(defn entries-in-range-json
  "Returns a json string with all the time series entries for the given
  `range`.  For details about the `range`, see
  `time-series-dispatch-on-range` in `time-series-db`."
  [db-spec project-id range]
  (tsc/entries-in-range-json db-spec project-id "code-coverage" range))


(comment
  ;; javascript can read this format.
  (f/unparse (:date-hour-minute-second-fraction f/formatters) (t/now))
  ;; => "2024-11-25T16:47:19.657"

  (tcoerce/to-timestamp (tcoerce/to-timestamp (t/now)))
  
  )
