(ns codescene.features.stripe.util
  (:import (clojure.lang Keyword)
           (java.time.temporal ChronoField TemporalAccessor)
           (java.util Date)
           (org.joda.time ReadableInstant)))

(defprotocol StripeParam
  (to-str [this]))

(extend-protocol StripeParam
  nil
  (to-str [this] this)
  Boolean
  (to-str [this] (str this))
  Keyword
  (to-str [this] (name this))
  String
  (to-str [this] this)
  Number
  (to-str [this] (str this))
  Date
  (to-str [this] (str (quot (.getTime this) 1000)))
  ReadableInstant
  (to-str [this] (str (quot (.getMillis this) 1000)))
  TemporalAccessor
  (to-str [this] (str (.getLong this ChronoField/INSTANT_SECONDS))))

(defn flatten-params
  "Flattens a parameter map into a single level map where keys follow
  Stripe's serialization plan.

  Keywords and dates are handled."
  [params]
  (letfn [(indexed [obj] (if (map? obj) obj (map-indexed vector obj)))
          (render-prefix [[k & others]]
            (apply str k (interleave (repeat \[) others (repeat \]))))
          (flatten-param [prefix param]
            (if (coll? param)
              (mapcat
                (fn [[idx v]] (flatten-param (conj prefix idx) v))
                (indexed param))
              [(render-prefix (map to-str prefix)) (to-str param)]))]
    (apply hash-map (flatten-param [] params))))
