(ns codescene.features.components.kv-store
  (:import (com.github.benmanes.caffeine.cache Cache Caffeine)
           (java.time Duration)))

(defprotocol KVStore
  (get-val [this k])
  (set-val [this k v] "Sets value into kv-store")
  (remove-val [this k] "Removes key, returns value"))

(defrecord CaffeineKvStore [^Cache cache]
  KVStore
  (get-val [this k] (.getIfPresent cache))
  (set-val [this k v] (.put cache k v))
  (remove-val [this k] (.remove (.asMap cache) k)))

(defn caffeine-kv-store [{:keys [expire-minutes max-size]}]
  (let [cache
        (cond-> (Caffeine/newBuilder)
          expire-minutes (.expireAfterWrite (Duration/ofMinutes expire-minutes))
          max-size (.maximumSize max-size)
          :always (.build))]
    (->CaffeineKvStore cache)))