(ns codescene.features.api.spec.project
  (:require [clojure.spec.alpha :as s]
            [spec-tools.spec :as spec]
            [codescene.specs :as codescene-specs]
            [codescene.features.api.spec.common :as common-spec]))

;;Project Configuration
;;
(s/def ::complete-history-for-social spec/boolean?)
(s/def ::temporal_coupling_across_minrevs spec/int?)
(s/def ::branch-name-exclusion-pattern spec/string?)
(s/def ::hotspots-sliding-window-time #{"1 month" "3 months" "6 months" "1 year" "2 years" "full"})
(s/def ::minrevs spec/int?)
(s/def ::calculate-branch-statistics spec/boolean?)
(s/def ::update-repositories spec/boolean?)
(s/def ::code-ownership-source-file-names spec/string?)
(s/def ::spottrendspan spec/int?)
(s/def ::ticketidpattern spec/string?)
(s/def ::max_history_depth spec/int?)
(s/def ::limit_branch_prediciton_commits spec/boolean?)
(s/def ::hotspots-defect-mining-pattern spec/string?)
(s/def ::exdevcontribenabled spec/int?)
(s/def ::complexitytrendwarninglookbackinmonths spec/int?)
(s/def ::code_comment_enabled spec/boolean?)
(s/def ::lookup-copied-content spec/boolean?)
(s/def ::delivery-performance-strategy #{"by-pm-transitions" "by-git-tags"})
(s/def ::ticket-id-uri-template (s/nilable spec/string?))
(s/def ::delivery-performance-release-tag (s/nilable spec/string?))
(s/def ::age-is-last-commit spec/boolean?)
(s/def ::max_branch_risk_history_depth spec/int?)
(s/def ::use-parallel-code-health-strategy spec/boolean?)
(s/def ::selectdistinctcommits spec/int?)
(s/def ::temporal_coupling_across_maxchangesetsize spec/int?)
(s/def ::rollingaveragedays spec/int?)
(s/def ::project_owner (s/nilable spec/string?))
(s/def ::team-analysis-sliding-window-time #{"1 month" "3 months" "6 months" "1 year" "2 years" "full"})
(s/def ::minexdevcontribtime spec/int?)
(s/def ::temporal_coupling_archlevel_across_minrevs spec/int?)
(s/def ::maxchangesetsize spec/int?)
(s/def ::disable-code-health-custom-rules spec/boolean?)
(s/def ::code-health-alert-level spec/int?)
(s/def ::modus_commit_message_pattern spec/string?)
(s/def ::exclusionfilter spec/string?)
(s/def ::auto-detect-text-files spec/boolean?)
(s/def ::delta-ignore-other-branches spec/boolean?)
(s/def ::whitelistcontent spec/string?)
(s/def ::xrayallrevisions spec/int?)
(s/def ::xray-min-coupling-degree spec/int?)
(s/def ::combine-authors-field-and-commit-msg-to-deduce-pairs? spec/boolean?)
(s/def ::git-rename-limit spec/int?)
(s/def ::max_historic_age spec/int?)
(s/def ::branches-analysis-lookback-weeks spec/nat-int?)
(s/def ::modus-commit-message-pattern spec/string?)
(s/def ::excludecontent spec/string?)
(s/def ::always-comment spec/boolean?)
(s/def ::coupling-threshold spec/int?)
(s/def ::qg-preset #{"global" "minimal" "medium" "all" "custom" "custom-file"})
(s/def ::qg-hotspot-decline? spec/boolean?)
(s/def ::qg-critical-health-rules? spec/boolean?)
(s/def ::qg-advisory-health-rules? spec/boolean?)
(s/def ::qg-new-code-health? spec/boolean?)
(s/def ::qg-refactoring-goals? spec/boolean?)
(s/def ::qg-supervise-goals? spec/boolean?)
(s/def ::codeowners-for-critical-code? spec/boolean?)

(s/def ::delta-branch-name-exclusion-pattern (s/nilable ::codescene-specs/valid-regex))
(s/def ::social_net_minsharedrevs spec/int?)
(s/def ::scan-all-code-in-project spec/boolean?)
(s/def ::global-code-health-custom-rules spec/string?)
(s/def ::pm-data-sliding-window-time #{"1 month" "3 months" "6 months" "1 year" "2 years" "full"})
(s/def ::social-net-min-shared-revs spec/int?)
(s/def ::pair-programming-pattern spec/string?)
(s/def ::pair-programming-author-message-pattern spec/string?)
(s/def ::temporal-coupling-strategy #{"by-ticket-id" "by-time"})
(s/def ::pm-data-remove-outliers spec/boolean?)
(s/def ::analysis-start-date (s/and string? #(not (empty? %)) #(re-matches common-spec/YYYY-MM-DD %)))
(s/def ::team-analysis-start-date (s/and string? #(not (empty? %)) #(re-matches common-spec/YYYY-MM-DD %)))
(s/def ::group-id spec/int?)
(s/def ::developer-configuration spec/int?)

(s/def ::new-config (s/keys :req-un []
                            :opt-un [::complete-history-for-social
                                     ::common-spec/description
                                     ::temporal_coupling_across_minrevs
                                     ::branch-name-exclusion-pattern
                                     ::hotspots-sliding-window-time
                                     ::minrevs
                                     ::calculate-branch-statistics
                                     ::update-repositories
                                     ::code-ownership-source-file-names
                                     ::spottrendspan
                                     ::ticketidpattern
                                     ::max_history_depth
                                     ::hotspots-defect-mining-pattern
                                     ::limit_branch_prediciton_commits
                                     ::exdevcontribenabled
                                     ::complexitytrendwarninglookbackinmonths
                                     ::code_comment_enabled
                                     ::lookup-copied-content
                                     ::pm-data-remove-outliers
                                     ::delivery-performance-strategy
                                     ::ticket-id-uri-template
                                     ::delivery-performance-release-tag
                                     ::age-is-last-commit
                                     ::common-spec/name
                                     ::max_branch_risk_history_depth
                                     ::use-parallel-code-health-strategy
                                     ::analysis-start-date
                                     ::selectdistinctcommits
                                     ::temporal_coupling_across_maxchangesetsize
                                     ::rollingaveragedays
                                     ::project_owner
                                     ::team-analysis-start-date
                                     ::team-analysis-sliding-window-time
                                     ::minexdevcontribtime
                                     ::temporal_coupling_archlevel_across_minrevs
                                     ::maxchangesetsize
                                     ::disable-code-health-custom-rules
                                     ::code-health-alert-level
                                     ::modus_commit_message_pattern
                                     ::exclusionfilter
                                     ::auto-detect-text-files
                                     ::whitelistcontent
                                     ::xrayallrevisions
                                     ::xray-min-coupling-degree
                                     ::combine-authors-field-and-commit-msg-to-deduce-pairs?
                                     ::git-rename-limit
                                     ::max_historic_age
                                     ::branches-analysis-lookback-weeks
                                     ::modus-commit-message-pattern
                                     ::excludecontent
                                     ::always-comment
                                     ::coupling-threshold
                                     ::qg-preset
                                     ::delta-branch-name-exclusion-pattern
                                     ::delta-ignore-other-branches
                                     ::social_net_minsharedrevs
                                     ::scan-all-code-in-project
                                     ::global-code-health-custom-rules
                                     ::pm-data-sliding-window-time
                                     ::social-net-min-shared-revs
                                     ::pair-programming-pattern
                                     ::pair-programming-author-message-pattern
                                     ::temporal-coupling-strategy
                                     ::group-id
                                     ::developer-configuration
                                     ::qg-preset
                                     ::qg-hotspot-decline?
                                     ::qg-critical-health-rules?
                                     ::qg-advisory-health-rules?
                                     ::qg-new-code-health?
                                     ::qg-refactoring-goals?
                                     ::qg-supervise-goals?
                                     ::codeowners-for-critical-code?]))

(s/def ::config (s/keys :req-un []
                        :opt-un [::complete-history-for-social
                                 ::common-spec/description
                                 ::temporal_coupling_across_minrevs
                                 ::branch-name-exclusion-pattern
                                 ::hotspots-sliding-window-time
                                 ::minrevs
                                 ::calculate-branch-statistics
                                 ::update-repositories
                                 ::code-ownership-source-file-names
                                 ::spottrendspan
                                 ::ticketidpattern
                                 ::max_history_depth
                                 ::hotspots-defect-mining-pattern
                                 ::limit_branch_prediciton_commits
                                 ::exdevcontribenabled
                                 ::complexitytrendwarninglookbackinmonths
                                 ::code_comment_enabled
                                 ::lookup-copied-content
                                 ::pm-data-remove-outliers
                                 ::delivery-performance-strategy
                                 ::ticket-id-uri-template
                                 ::delivery-performance-release-tag
                                 ::age-is-last-commit
                                 ::common-spec/name
                                 ::max_branch_risk_history_depth
                                 ::use-parallel-code-health-strategy
                                 ::analysis-start-date
                                 ::selectdistinctcommits
                                 ::temporal_coupling_across_maxchangesetsize
                                 ::rollingaveragedays
                                 ::project_owner
                                 ::team-analysis-start-date
                                 ::team-analysis-sliding-window-time
                                 ::minexdevcontribtime
                                 ::temporal_coupling_archlevel_across_minrevs
                                 ::maxchangesetsize
                                 ::disable-code-health-custom-rules
                                 ::code-health-alert-level
                                 ::modus_commit_message_pattern
                                 ::exclusionfilter
                                 ::auto-detect-text-files
                                 ::whitelistcontent
                                 ::xrayallrevisions
                                 ::xray-min-coupling-degree
                                 ::combine-authors-field-and-commit-msg-to-deduce-pairs?
                                 ::git-rename-limit
                                 ::max_historic_age
                                 ::branches-analysis-lookback-weeks
                                 ::modus-commit-message-pattern
                                 ::excludecontent
                                 ::always-comment
                                 ::coupling-threshold
                                 ::delta-branch-name-exclusion-pattern
                                 ::delta-ignore-other-branches
                                 ::social_net_minsharedrevs
                                 ::scan-all-code-in-project
                                 ::global-code-health-custom-rules
                                 ::pm-data-sliding-window-time
                                 ::social-net-min-shared-revs
                                 ::pair-programming-pattern
                                 ::pair-programming-author-message-pattern
                                 ::temporal-coupling-strategy
                                 ::group-id
                                 ::developer-configuration]))

(s/def ::id spec/int?)
(s/def ::active_authors ::common-spec/optional-decimal-number)
(s/def ::duration_of_last_analysis_in_seconds ::common-spec/optional-decimal-number)
(s/def ::last_access_date spec/string?)
(s/def ::project_activity (s/keys :req-un [::id ::common-spec/name ::project_owner ::active_authors ::duration_of_last_analysis_in_seconds ::last_access_date]))
(s/def ::projects_activity (s/coll-of ::project_activity))

(s/def ::name spec/string?)
(s/def ::patterns (s/coll-of spec/string?))
(s/def ::component-config (s/keys :req-un [::name ::patterns]))
(s/def ::component-config-list (s/coll-of ::component-config))

;; Project list ordering - supports ordering by name and analysis summary fields
(s/def ::project_list_order_by #{"name"
                                 "analysis.code_health.now" "analysis.code_health.month" "analysis.code_health.year"
                                 "analysis.code_health.change_month" "analysis.code_health.change_year"
                                 "analysis.hotspot_code_health.now" "analysis.hotspot_code_health.month" "analysis.hotspot_code_health.year"
                                 "analysis.hotspot_code_health.change_month" "analysis.hotspot_code_health.change_year"
                                 "analysis.authors.total" "analysis.authors.active"})
