// @flow
import $ from 'jquery';

import * as alerts from 'codescene-ui/src/alerts';
import * as xhr from 'codescene-ui/src/browser/xhr';
import * as socialNetwork from 'codescene-ui/src/analyses/social-network';

export function init(options: { socialNetworkUrl : string }) {
  const container = $('#socialnetvisualization');
  const infoText = $('.text-info');

  xhr.json(options.socialNetworkUrl)
    .then(socialNetworkClasses => {
      if (socialNetworkClasses && socialNetworkClasses.length > 0) {
        socialNetwork.draw(socialNetworkClasses, container);
      } else {
        infoText.remove();
        container.html('<div class="text-muted">There are no strong communication paths.</div>');
      }
    })
    .catch(err => {
      console.error(err);
      alerts.error(container, 'Failed to load social network data.');
    });
}
