// @flow
import $ from 'jquery';

import * as xhr from 'codescene-ui/src/browser/xhr';
import * as tabulator from 'codescene-ui/src/tabulator';
import * as tableSorter from 'codescene-ui/src/table-sorter';

type ViewOptions = {
  risingHotspotsUrl : string,
  projectId : number,
  analysisId : number
};

function renderTable(container : $, data : Array<any>, options : ViewOptions) {
  var table = tabulator.tabulate(container.get(0), data, ['name','delta','newrank', 'oldrank'])
    .classed('table-hover', true);

  // better names for the columns
  table.selectAll('thead th')
    .text(function(column, i) {
      if (i === 0) {
        return 'File Name';
      }
      else if (i === 1) {
        return 'Change Frequency Increase';
      }
      else if (i === 2) {
        return 'New Hotspot Rank';
      }
      else if (i === 3) {
        return 'Old Hotspot Rank';
      }
      return column;
    });

  // Wrap module names in anchor and code element:
  table.selectAll('td.column-name')
    .html(function (d) { 
      const trendUrl = window.baseUrl + options.projectId + '/analyses/' + options.analysisId +
            '/code/hotspots/complexity-trend?name=' + encodeURIComponent(d.value);
      return `<a href="${trendUrl}"><span class="filename">${d.value}</span></a>`;
    });

  tableSorter.sort($(table.node()), {
    sortList: [[2, 0]],
    sortInitialOrder: 'desc'
  });
}

function parseRow(row) {
  return {
    name: row.name,
    revision: parseInt(row.revision),
    oldrank: parseInt(row.oldrank),
    newrank: parseInt(row.newrank),
    delta: parseInt(row.rank) // NOTE: the field name in the CSV is misleading!
  };
}

export function init(options : ViewOptions) {
  const container = $('#tableview');
  xhr.csv(options.risingHotspotsUrl, parseRow)
    .then(data => {
      renderTable(container, data, options);
    });
}

