-- name: delete-all-roles!
delete from roles cascade;

-- name: delete-role-by-name!
delete from roles where name = ?;

-- name: get-all-roles
select id, name from roles;

-- name: get-role-by-id
select id, name from roles where id = ?;

-- name: get-role-by-name
select id, name from roles where name = ?;

-- name: insert-role<!
insert into roles
       (name)
       values(:name);

-- name: roles-with-name
select id, name from roles where name = ?;

-- name: get-privileges-by-id
select privilege from role_privileges where id = ?;

-- name: get-all-roles-with-privileges
select r.id as role_id, r.name as role_name, p.privilege as privilege
from roles as r
join role_privileges as p on r.id = p.id;

-- name: insert-privilege!
insert into role_privileges
       (id, privilege)
       values(?, ?);

-- name: delete-privilege!
delete from role_privileges where id = :id and privilege = :privilege;
