-- name: select-provider-by-id
select id, type, name, active, api_url, username, password
from pm_data_providers
where id = :id

-- name: select-providers
select id, type, name, active, api_url, username, password, project_id
from pm_data_providers

-- name: select-providers-by-project
select id, type, name, active, api_url, username, password
from pm_data_providers
where project_id = :project_id

-- name: insert-provider<!
insert into pm_data_providers
    (project_id, type, name, active, api_url, username, password)
values (:project_id, :type, :name, :active, :api_url, :username, :password)

-- name: update-provider-by-id!
update pm_data_providers
set type =:type, name =:name, active =:active, api_url =:api_url, username =:username, password =:password
where id = :id

-- name: delete-provider-by-id!
delete from pm_data_providers
where id = :id

-- name: select-provider-config-by-id
select `key`, `value`
from pm_data_providers_config
where provider_id = :provider_id

-- name: insert-provider-config-property!
-- Inserts  a single key-value pair representing specifig config property for given provider
INSERT INTO pm_data_providers_config (provider_id, `key`, `value`)
VALUES (:provider_id, :key, :value);

-- name: update-provider-config-property!
-- Updates a single key-value pair representing specifig config property for given provider
UPDATE pm_data_providers_config
SET `value` = :value
WHERE provider_id = :provider_id AND `key` = :key
