// Compiled by ClojureScript 1.11.60 {:optimizations :none}
goog.provide('same.core');
goog.require('cljs.core');
goog.require('same.compare');
goog.require('same.ish');
/**
 * Compare one or more values to an expected value, returning true if they are the same-ish.
 *   The values can be numbers:
 *   ```klipse
 *   (let [two (Math/pow (Math/sqrt 2) 2)]
 *  [(== 2 two) (ish? 2 two)])
 *   ```
 *   or data structures:
 *   ```klipse
 *   (ish? {:a 1 :b [1.99999999999999 3]}
 *      {:a 1.00000000000001 :b [2 3.0]})
 *   ```
 *   you can also compare more than one value to the expected value:
 *   ```klipse
 *   (ish? 1 1.0 0.99999999999999 1.00000000000001 1)
 *   ```
 */
same.core.ish_QMARK_ = (function same$core$ish_QMARK_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___13489 = arguments.length;
var i__5770__auto___13490 = (0);
while(true){
if((i__5770__auto___13490 < len__5769__auto___13489)){
args__5775__auto__.push((arguments[i__5770__auto___13490]));

var G__13491 = (i__5770__auto___13490 + (1));
i__5770__auto___13490 = G__13491;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return same.core.ish_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(same.core.ish_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (expected,actuals){
if(cljs.core.truth_(cljs.core.not_empty.call(null,actuals))){
} else {
throw (new Error("Assert failed: (not-empty actuals)"));
}

return cljs.core.every_QMARK_.call(null,cljs.core.partial.call(null,same.ish.ish,expected),actuals);
}));

(same.core.ish_QMARK_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(same.core.ish_QMARK_.cljs$lang$applyTo = (function (seq13487){
var G__13488 = cljs.core.first.call(null,seq13487);
var seq13487__$1 = cljs.core.next.call(null,seq13487);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__13488,seq13487__$1);
}));

/**
 * Compare a numeric value to zero, returning true if close.
 *   ```klipse
 *   (zeroish? 0.0000000001
 *          :scale 1e6)
 *   ```
 */
same.core.zeroish_QMARK_ = (function same$core$zeroish_QMARK_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___13496 = arguments.length;
var i__5770__auto___13497 = (0);
while(true){
if((i__5770__auto___13497 < len__5769__auto___13496)){
args__5775__auto__.push((arguments[i__5770__auto___13497]));

var G__13498 = (i__5770__auto___13497 + (1));
i__5770__auto___13497 = G__13498;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return same.core.zeroish_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(same.core.zeroish_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (val,p__13494){
var map__13495 = p__13494;
var map__13495__$1 = cljs.core.__destructure_map.call(null,map__13495);
var scale = cljs.core.get.call(null,map__13495__$1,new cljs.core.Keyword(null,"scale","scale",-230427353),1000.0);
return same.compare.near_zero.call(null,val,scale);
}));

(same.core.zeroish_QMARK_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(same.core.zeroish_QMARK_.cljs$lang$applyTo = (function (seq13492){
var G__13493 = cljs.core.first.call(null,seq13492);
var seq13492__$1 = cljs.core.next.call(null,seq13492);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__13493,seq13492__$1);
}));

/**
 * Compare a numeric value to zero, returning true if not close. Equivalent to `(not (zeroish? ...))`.
 *   ```klipse
 *   (not-zeroish? 3 :scale 1e6)
 *   ```
 */
same.core.not_zeroish_QMARK_ = (function same$core$not_zeroish_QMARK_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___13503 = arguments.length;
var i__5770__auto___13504 = (0);
while(true){
if((i__5770__auto___13504 < len__5769__auto___13503)){
args__5775__auto__.push((arguments[i__5770__auto___13504]));

var G__13505 = (i__5770__auto___13504 + (1));
i__5770__auto___13504 = G__13505;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return same.core.not_zeroish_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(same.core.not_zeroish_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (val,p__13501){
var map__13502 = p__13501;
var map__13502__$1 = cljs.core.__destructure_map.call(null,map__13502);
var scale = cljs.core.get.call(null,map__13502__$1,new cljs.core.Keyword(null,"scale","scale",-230427353),1000.0);
return (!(same.compare.near_zero.call(null,val,scale)));
}));

(same.core.not_zeroish_QMARK_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(same.core.not_zeroish_QMARK_.cljs$lang$applyTo = (function (seq13499){
var G__13500 = cljs.core.first.call(null,seq13499);
var seq13499__$1 = cljs.core.next.call(null,seq13499);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__13500,seq13499__$1);
}));

/**
 * Set the default comparator.
 *   ```klipse
 *   (set-comparator! (compare-ulp 2.0 100))
 *   (ish? 0.1 (-> 2 Math/sqrt (Math/pow 2) (- 1.9)))
 *   ```
 */
same.core.set_comparator_BANG_ = (function same$core$set_comparator_BANG_(comparator){
(same.ish._STAR_comparator_STAR_ = comparator);

return null;
});
var ret__5824__auto___13510 = (function (){
/**
 * Temporarily replace the default comparator.
 *   ```klipse
 *   (with-comparator (compare-ulp 100.0 1e9)
 *  (ish? 1.0 0.9999999))
 *   ```
 *   ```klipse
 *   (with-comparator ==
 *  (ish? 1.0 0.9999999999999))
 *   ```
 */
same.core.with_comparator = (function same$core$with_comparator(var_args){
var args__5775__auto__ = [];
var len__5769__auto___13511 = arguments.length;
var i__5770__auto___13512 = (0);
while(true){
if((i__5770__auto___13512 < len__5769__auto___13511)){
args__5775__auto__.push((arguments[i__5770__auto___13512]));

var G__13513 = (i__5770__auto___13512 + (1));
i__5770__auto___13512 = G__13513;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((3) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((3)),(0),null)):null);
return same.core.with_comparator.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5776__auto__);
});

(same.core.with_comparator.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,comparator,body){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cljs.core","binding","cljs.core/binding",2050379843,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("same.ish","*comparator*","same.ish/*comparator*",-1083476129,null),null,(1),null)),(new cljs.core.List(null,comparator,null,(1),null)))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"do","do",1686842252,null),null,(1),null)),body))),null,(1),null)))));
}));

(same.core.with_comparator.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(same.core.with_comparator.cljs$lang$applyTo = (function (seq13506){
var G__13507 = cljs.core.first.call(null,seq13506);
var seq13506__$1 = cljs.core.next.call(null,seq13506);
var G__13508 = cljs.core.first.call(null,seq13506__$1);
var seq13506__$2 = cljs.core.next.call(null,seq13506__$1);
var G__13509 = cljs.core.first.call(null,seq13506__$2);
var seq13506__$3 = cljs.core.next.call(null,seq13506__$2);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__13507,G__13508,G__13509,seq13506__$3);
}));

return null;
})()
;
(same.core.with_comparator.cljs$lang$macro = true);


//# sourceMappingURL=core.js.map
