lexer grammar RubySharedRulesLexer;

fragment ESCAPED : '\\\\' | '\\"' | '\\\'';
// TODO: Ruby supports only \' and \\ within single-quote strings
LITERAL : '"' ( ESCAPED | ~('\n'|'\r') )*? '"'
        | '\'' ( ESCAPED | ~('\n'|'\r') )*? '\'';

CLASS : 'class';
SELF : 'self';

COMMA : ',';
SEMICOLON : ';';
CRLF : '\r'? '\n';
DOT : '.';

END : 'end';

DEF : 'def';
RETURN : 'return';

SINGLE_LINE_IF: 'if:'; // just match the token so that we can wildcard it during parsing.
IF: 'if';
ELSEIF: 'elsif';
ELSE: 'else';
THEN: 'then';

UNLESS : 'unless';
UNTIL : 'until';
WHILE : 'while';
BREAK : 'break';
FOR : 'for';
DO : 'do';
DOT_EACH: '.each';

CASE : 'case';
WHEN: 'when';

BEGIN : 'begin';
ESC_MODULE: ':module' | 'module:';
MODULE : 'module';

STAR: '*';

// Logical operators
LOGICAL_OPERATORS: 'and' | '&&' | 'or' | '||';

// BDD test tokens
DESCRIBE: 'describe';
CONTEXT: 'context';
IT: 'it';

// Exception handling tokens
RAISE: 'raise';
RESCUE: 'rescue';
RETRY: 'retry';

LEFT_RBRACKET : '(';
RIGHT_RBRACKET : ')';
LEFT_SBRACKET : '[';
RIGHT_SBRACKET : ']';

REGEX : ('/' ~('\r' | '\n' | '/')*? '/') -> skip; // the regex may contain block elements like class, module, do, etc

SL_COMMENT : ('#' ~('\r' | '\n')*) -> skip;
ML_COMMENT : ('=begin' .*? '=end\n') -> skip;
WS : (' '|'\t')+ -> skip;

ID : [a-zA-Z_][a-zA-Z0-9_]*;
ID_GLOBAL : '$'ID;
ID_FUNCTION : ID[?!];

ANY_CHAR : .; // Put this lexer rule last to give it the lowest precedence