// This is the ECMA script grammar with additions necessary to parse TypeScript too.
// We've chosen to combine these two grammars since TypeScript is a strict superset of ECMA.

grammar PHP;
options {superClass=hotspots_x_ray.languages.InterruptibleParser;}

import PHPSharedRulesLexer;

translationunit
:
	global_expression* EOF
;

// Use two separate rules for expressions since we only want to capture
// global variables that are truly global. That is, we don't want to
// capture variables declared inside a limited scope like the following global code:
// <?php
//} else {
//  $url_c = geturlarray($url);
//  $params = array_merge($_GET, $_POST);
//
// In the code above, $url_c and $params aren't global variables -- they're local to the else-scope.
// Without this separation of rules we bias our cohesion metrics.

global_expression : function_declaration
                  | global_variable
                  | class_block
                  | top_level_block_statement
                  | global_anything;

expression : function_declaration
           | class_block
           | top_level_block_statement
           | global_anything;

// Use a separate "anything" to detect code in global scope. We need this
// for cohesion calulcations.
global_anything : ~(LeftBrace | RightBrace);
anything : ~(LeftBrace | RightBrace);

variable_field: PARAMETER_NAME;
global_variable: variable_field ASSIGN;

class_block: CLASS class_name anything*? LeftBrace class_body*? RightBrace;

class_name: ID;

class_body: instance_or_class_variable
          | member_function
          | class_block_statement
          | anything;

instance_or_class_variable: access_rule variable_field (SEMICOLON | '=');
access_rule: 'private' | 'public' | 'protected';

member_function: FUNCTION member_function_name function_scope;

member_function_name: ID;

class_block_statement : LeftBrace class_block_statement_content*? RightBrace;
class_block_statement_content: class_block_statement | anything;

top_level_block_statement : LeftBrace expression*? RightBrace;

function_declaration : FUNCTION function_name function_scope
                     | function_name '=' FUNCTION function_scope;

function_name: ID | SCOPED_NAME | PARAMETER_NAME;

function_scope: LeftParen function_definition_params_list? RightParen return_type? LeftBrace function_body RightBrace;

return_type: COLON ~LeftBrace*?;

function_definition_params_list : function_param
                                | function_definition_params_list COMMA function_param
                                ;

function_param: plain_param
              | variable_params
              | param_with_default_value;

plain_param: type_hint? parameter_name;
variable_params: type_hint? TRIPLE_DOTS parameter_name;
param_with_default_value: plain_param '=' parameter_default_value;
parameter_name: (PARAMETER_NAME | ID);
type_hint: ID;
parameter_default_value: simple_default | complex_default;
simple_default: .; // like "hey, there" or 42
complex_default: ID LeftParen complex_default_arguments? RightParen
               | '[' complex_default_arguments? ']';
complex_default_arguments: parameter_default_value
                         | complex_default_arguments COMMA parameter_default_value;

function_body : function_body_statement*?;

function_body_statement : block_statement
                        | anything;

block_statement : LeftBrace function_body_statement*? RightBrace;

BlockComment: '/*' .*? '*/' -> skip;
