grammar JavaCohesion;

import JavaSharedRulesParser;

translationunit
:
	expression* EOF
;

expression : class_declaration
           //| record_declaration
           | block_statement
           | anything;

// override the shared rule: we want to swallow nested classes since we don't
// calculate cohesion on their methods:
anything : ~(LeftBrace | RightBrace);

// We only want a possible variable once we know that we're inside a class.
class_declaration : CLASS class_name ~LeftBrace*? LeftBrace inside_class_expression*? RightBrace;
//... which also includes Records that can have methods too:
record_declaration : RECORD class_name ~LeftBrace*? LeftBrace inside_class_expression*? RightBrace;

variable_field: variable_name (';' | property_with_object_initialization | '=');
variable_name: ID;

inside_class_expression : variable_field
                        | property_with_object_initialization
                        | function_declaration
                        | block_statement
                        | anything;

property_with_object_initialization : '=' 'new'  (ID | SCOPED_NAME) LeftParen function_definition_params_list? RightParen LeftBrace inside_object_initialization+ RightBrace;

inside_object_initialization : block_statement
                             | anything;
