(ns codescene.features.reports.common.glossary
  (:require [codescene.features.reports.common.styling :as styling]
            [codescene.features.reports.pdf-helpers :as ph]))


(defn- title-and-text-row [title text]
  (ph/row (ph/cell []
                   (ph/paragraph [:glo-title-paragraph] title)
                   (ph/paragraph [:glo-text-paragraph] text))))

(defn- title-and-image-row [title image]
  (ph/row (ph/cell []
                   (ph/paragraph [:glo-title-paragraph] title)
                   (ph/table [:glo-image-table] nil (ph/row (ph/image [:glo-image] image))))))


(defn pdf-element [{:keys [img-dir]}]
  (let [ch-img (styling/load-resource img-dir "glossary-ch.png")]
    [(ph/paragraph [:c-page-header-paragraph] "CodeScene Terminology ")
     (ph/table
       [:glo-top-table] nil
       (title-and-text-row "Active Contributors"
                           "Anyone who has committed code to repositories that are part of this project, during this reporting period.")
       (title-and-text-row "4 Factor Dashboard"
                           "CodeScene’s main dashboard shows the current status and trend for each project across 4 factors: Code Health, Knowledge Distribution, Team-Code Alignment and Delivery. ")
       (title-and-text-row "Software Portfolio Overview"
                           "A high level overview of all your projects and their status across the 4 factors.")
       (title-and-text-row "Hotspots"
                           "Hotspots are files with the highest development activity. It is where the team spends most of their development time. Hotspots point to modules that are likely to have a high business impact.")
       (title-and-text-row "Code Health"
                           "An aggregated metric based on 25+ factors scanned from the source code. The Code Health score goes from 10 (healthy code that’s easy to understand and evolve) down to 1 (code with severe quality issues). ")
       (title-and-image-row "Code Health Score and Status" ch-img)
       (title-and-text-row "Knowledge Distribution"
                           "Knowledge Distribution measures the current state of Code Familiarity – how much of the code is written by the current team - as well as the risk in terms of Knowledge Islands, which represent potential key personnel risks.")
       (title-and-text-row "Team-Code Alignment"
                           "Shows how well aligned the development teams are with the software architecture. An efficient team structure minimizes dependencies and coordination overhead.")
       (title-and-text-row "Delivery"
                           "Delivery is an output metric that captures the efficiency of the overall development process. This metric is influenced both by process and by how well you do on the other factors; healthy code, strong knowledge growth, and team/code alignment are all pre-requisites for efficient delivery.")
       (title-and-text-row "PM Tool Integration"
                           "Integrate Jira, Trello, Azure DevOps, or GitHub Issues. Reason about technical findings from a financial perspective. How much time do you spend on defects in your hotspots? What amount of work is unplanned? ")
       (title-and-text-row "Pull Request Integration"
                           "CodeScene automates a Delta Analysis via webhooks to Pull Requests. This integration is used as input to code reviews and/or as a quality gate (e.g. fix the code health degradations before merge). ")
       (title-and-text-row "PR Checks Performed"
                           "The number of Pull Request checks that CodeScene performed on this project during a specific period. ")
       (title-and-text-row "Findings"
                           "A finding is either a violated goal (e.g. a planned refactoring never happened), a code health decline, or new code with code health issues. CodeScene provides PR statistics showing what portion of those findings was fixed, ignored or suppressed."))]))
