(ns codescene.features.pm-data.bitbucket-server.cache
  "Wraps some fetcher fns to make them cacheable"
  (:require [codescene.features.pm-data.bitbucket-server.fetcher :as bbf]
            [codescene.features.pm-data.cache :as cache]))

(defn- fetch-pull-requests-key-fn
  [_ _ {:keys [host owner-login repo-slug]}]
  [host owner-login repo-slug])

(def ^:private fetch-pull-requests-cacheable (cache/make-cacheable bbf/fetch-pull-requests))
(cache/memo #'fetch-pull-requests-cacheable fetch-pull-requests-key-fn)

(defn fetch-pull-requests
  [since api-client repo-info]
  (cache/combine-with-cache fetch-pull-requests-cacheable fetch-pull-requests-key-fn 
                            since api-client repo-info))

(comment
  (def api-client (codescene.features.client.api/->ExtraProperties
                   {:api-url "http://localhost:7990/rest/api/1.0"}
                   (System/getenv "BITBUCKET_SERVER_TOKEN")))
  (def repo-info (codescene.url.url-utils/repo-url->repo-info  "ssh://git@localhost:7999/te/analysis-target.git" :bitbucket false))
  (let [since (evolutionary-metrics.trends.dates/string->date "2022-01-22")]
    (codescene.cache.core/with-file-cache "." "." :pm-data
      {:fetch-pull-requests (count (fetch-pull-requests since api-client repo-info))})))
