(ns codescene.features.factors.diagnostics
  "Combine the codescene.factors.analysis-diagnostics output with run-time based
  diagnostic info, such as the current configuration.
  This is still a work in progress, and the separation from the other diagnostic ns
  is not very useful yet.

  We use the following input:
  - analysis configuration in the database
  - output from the 'analysis-diagnostics' ns which include data quality

  The output is a list of diagnostic messages, that is easily interpretable by
  the UI and can help the user fix their configuration or data sources.
  "
  (:require
    [codescene.factors.analysis-diagnostics :as analysis-diagnostics]
    [clojure.java.io :as io]
    [codescene.analysis.paths :as paths]
    [codescene.util.json :as json]))

(defn- has-previous-four-factor-analysis-run? [analysis-results-path]
  ;; TODO change to VERSION or a marker file somewhere?
  ;; until then we check if the knowledge ts exists
  (let [f (io/file analysis-results-path paths/four-factors-configuration-diagnosis-json)]
    (when (.exists f)
      (json/read f))))

(defn- append-to-all-factors [diagnosis  problem]
  (-> diagnosis
      (update :code-health conj problem)
      (update :knowledge-distribution conj problem)
      (update :team-code-alignment conj problem)
      (update :delivery-performance conj problem)))

(defn- diagnose-four-factors [analysis-results-path]
  (let [analysis-out-of-date {:problem :analysis-out-of-date
                              :actions [:block-factor]
                              :parameters {}}]
    (cond-> {}
      (not (has-previous-four-factor-analysis-run? analysis-results-path)) (append-to-all-factors analysis-out-of-date))))

(defn- merge-diagnoses [d1 d2]
  (reduce (fn [acc k]
            (assoc acc k (concat (get d1 k []) (get d2 k []))))
          {}
          [:code-health :knowledge-distribution :team-code-alignment :delivery-performance]))

(defn diagnose [analysis-results-path]
  (let [post-analysis-diagnosis (analysis-diagnostics/read-diagnosis analysis-results-path)
        run-time-diagnosis (diagnose-four-factors analysis-results-path)]
    (merge-diagnoses post-analysis-diagnosis run-time-diagnosis)))

