(ns codescene.features.delta.events
  (:require [codescene.delta.delta-result :as delta-result]
            [codescene.delta.statistics.pr-statistics :as pr-statistics]
            [codescene.features.delta.code-health.ch-gates :as ch-gates]
            [medley.core :as m]))

(defn- limit-size-for-amplitude
  [coll]
  (when (< (count coll) 100)
    coll))

(defn delta-result-props
  [suppressions {:keys [authors commits qg-meta file-results] :as result}]
  (let [negative-findings (delta-result/negative-findings result)
        positive-findings (delta-result/positive-findings result)
        {:keys [added removed]} (delta-result/directives result)
        files (delta-result/files result)
        {:keys [qg-profile new-file-threshold]} qg-meta]
    ;; Always add counts to ensure we have some data even
    ;; if the detailed data is too large to be included                         
    (m/assoc-some {:n-negative-findings (count negative-findings)
                   :n-positive-findings (count positive-findings)
                   :n-suppressions (pr-statistics/suppressed-findings suppressions negative-findings)
                   :n-added-directives (count added)
                   :n-removed-directives (count removed)
                   :n-authors (count authors)
                   :n-commits (count commits)
                   :n-files (count files)
                   :enabled-gates (ch-gates/enabled-gates-in file-results)
                   :failed-gates (ch-gates/failed-gates suppressions file-results)
                   :qg-profile qg-profile
                   :new-file-threshold new-file-threshold}

                  :negative-findings (limit-size-for-amplitude negative-findings)
                  :positive-findings (limit-size-for-amplitude positive-findings)
                  :directives (limit-size-for-amplitude added)
                  :author (first authors)
                  :authors (limit-size-for-amplitude authors)
                  :commits (limit-size-for-amplitude commits)
                  :files (limit-size-for-amplitude files)
                  ;; this is populated by run-delta-analysis function
                  :durations (meta result))))

