(ns codescene.features.delta.coverage.cov-config
  (:require [clojure.spec.alpha :as s]
            [codescene.features.delta.integration.integration-config :as ic]
            [codescene.features.api.spec.code-coverage :as cc-spec]
            [codescene.features.config.properties :refer [enum bool sval property ival] :as p]))

(s/def ::cov-qg-preset #{"global" "minimal" "medium" "all" "custom" "custom-file"})
(s/def ::initialize-check-run #{"always" "on-post"})

(def provider-properties
  {:github [(property :initialize-check-run :cov-initialize-check-run (enum ::initialize-check-run) "always")]
   :azure []
   :bitbucket []
   :gitlab []
   :none []})

(def qg-properties [(property :cov-qg-preset :cov-qg-preset (enum ::cov-qg-preset) "global")
                    (property :overall-coverage? :qg-overall-coverage (bool) false)
                    (property :new-and-changed-code? :qg-new-and-changed-code (bool) true)
                    (property :no-decline-in-coverage? :qg-no-decline-in-coverage (bool) false)
                    (property :new-file-coverage? :qg-new-file-coverage (bool) false)
                    (property :hotspot-must-improve? :qg-hotspot-must-improve (bool) false)
                    (property :modified-must-improve? :qg-modified-must-improve (bool) false)
                    (property :hotspot-coverage-target? :qg-hotspot-coverage-target (bool) false)])

(def settings-properties
  (into [(property :coverage-metric :cov-coverage-metric (enum ::cc-spec/metric) "line-coverage")
         (property :overall-threshold :cov-overall-threshold (ival) 80)
         (property :changed-threshold :cov-changed-threshold (ival) 95)]
        qg-properties))

(def settings-properties'
  "Settings but with integration setting for ignoring other branches, as seen on preset pages"
  (conj settings-properties ic/prop-ignore-other-branches))

(def qg-properties-keys (mapv :id qg-properties))
(def qg-properties-keys-wo-preset (next qg-properties-keys))

(defn profile [props]
  (let [profile-name (:cov-qg-preset props)
        all-false (zipmap qg-properties-keys-wo-preset (repeat false))
        all-true (zipmap qg-properties-keys-wo-preset (repeat true))]
    (merge props
           all-false
           (get {"minimal" {:overall-coverage? true
                            :new-and-changed-code? true}
                 "medium" {:overall-coverage? true
                           :new-and-changed-code? true
                           :no-decline-in-coverage? true
                           :new-file-coverage? true}
                 "all" all-true
                 "custom" props}
                profile-name))))

(defn remove-preset-props
  "Removes properties from property list (except preset itself) that are specified in global preset."
  [properties]
  (let [p (disj (into #{} (map :id settings-properties)) :cov-qg-preset)]
    (remove (comp p :id) properties)))

(def properties (update-vals provider-properties #(into % settings-properties')))
