(ns codescene.features.config.presets-db
  (:require [hugsql.core :as hugsql]
            [codescene.features.util.maps :refer [->kebab? ->db-keys map-of-db]]
            [taoensso.timbre :as log]))

(hugsql/def-db-fns "codescene/features/config/presets.sql")

(defn list-settings
  [db-spec scope page pagelen]
  (->> (select-settings db-spec (->db-keys (merge scope {:offset (* pagelen (or page 0)) :pagelen pagelen})))
       (mapv ->kebab?)))

(defn delete-settings
  [db-spec id]
  (delete-settings! db-spec {:id id}))

(defn active-settings-by-categories
  [db-spec categories scope]
  (->> (select-active-settings-by-categories db-spec (->db-keys (assoc scope :categories categories))
                                             {:connection db-spec})
       (mapv ->kebab?)))

(defn get-settings
  "Scope is something like group ID or account ID"
  [db-spec id scope]
  (some-> (select-single-settings db-spec (->db-keys (assoc scope :id id)))
          ->kebab?))

(defn get-settings-kv
  [db-spec id]
  (into {} (map (juxt (comp keyword :setting_key)
                      :setting_value))
        (select-settings-kv db-spec (map-of-db id))))

(defn insert-settings [db-spec params]
  (-> (insert-settings! db-spec (->db-keys params)) first val))

(defn update-settings [db-spec {:keys [label active? id]}]
  (update-settings! db-spec (map-of-db label active? id)))

(defn update-settings-kv [db-spec id k v]
  (update-settings-kv! db-spec {:settings_id id
                                :setting_key (name k)
                                :setting_value (str v)}))

(defn insert-settings-kv [db-spec id k v]
  (insert-settings-kv! db-spec {:settings_id id
                                :setting_key (name k)
                                :setting_value (str v)}))

(defn delete-settings-kv [db-spec id k]
  (delete-settings-kv! db-spec {:settings_id id
                                :setting_key (name k)}))

(defn get-settings-ids-by-category
  "Returns list of {:id, :active? }."
  [db-spec category]
  (mapv ->kebab? (settings-ids-by-category db-spec {:category category})))
