-- :name delete-settings! :! :n
delete from settings where id = :id;

-- :name select-settings :? :*
select * from settings where 1=1
--~ (when (contains? params :account_id) (if (params :account_id) " AND account_id = :account_id" " AND account_id is null"))
--~ (when (contains? params :group_id) (if (params :group_id) " AND group_id = :group_id" " AND group_id is null"))
LIMIT :pagelen OFFSET :offset;

-- :name select-active-settings-by-categories :? :*
select * from settings where category in (:v*:categories) and active = true
--~ (when (contains? params :account_id) (if (params :account_id) " AND account_id = :account_id" " AND account_id is null"))
--~ (when (contains? params :group_id) (if (params :group_id) " AND group_id = :group_id" " AND group_id is null"))
;

-- :name select-single-settings :? :1
select * from settings where id = :id
--~ (when (contains? params :account_id) (if (params :account_id) " AND account_id = :account_id" " AND account_id is null"))
--~ (when (contains? params :group_id) (if (params :group_id) " AND group_id = :group_id" " AND group_id is null"))
;

-- :name select-settings-kv :? :*
select * from settings_kv where settings_id = :id

-- :name insert-settings! :insert
insert into settings(label,
--~ (when (contains? params :account_id) "account_id, ")
--~ (when (contains? params :group_id) "group_id, ")
category, active) values (:label,
--~ (when (contains? params :account_id) ":account_id, ")
--~ (when (contains? params :group_id) ":group_id, ")
:category, true);

-- :name update-settings! :! :n
update settings SET label = :label, active = :active WHERE id = :id;

-- :name update-settings-kv! :! :n
update settings_kv SET setting_value = :setting_value WHERE settings_id = :settings_id and setting_key = :setting_key;

-- :name insert-settings-kv! :insert
insert into settings_kv(settings_id, setting_key, setting_value) values (:settings_id, :setting_key, :setting_value);

-- :name delete-settings-kv! :! :n
delete from settings_kv where settings_id = :settings_id AND setting_key = :setting_key

-- :name settings-ids-by-category :? :*
select id, active from settings where category = :category