(ns codescene.features.components.ff
  (:require [clojure.spec.alpha :as s]
            [codescene.features.components.core :as c]))

(defprotocol FFComponent
  (-on?
    [this flag]
    [this flag account-id]))

(defn on?
  "Return true if flag is on for entire product or for a particular account-id"
  ([this flag]
  (-on? this flag))
  ([this flag account-id]
   (-on? this flag account-id)))

(defn component [system]
  (c/find-component system :codescene.features.components/ff))

(defn ff-on?
  ([system flag]
   (on? (component system) flag))
  ([system flag account-id]
   (if account-id
     (on? (component system) flag account-id)
     (ff-on? system flag))))

(s/fdef on?
        :args (s/or :two (s/cat :this some?
                                :flag keyword?)
                    :three (s/cat :this some?
                                :flag keyword?
                                :account-id pos-int?))
        :ret boolean?)