(ns codescene.features.api.spec.pm-integration
  (:require
    [clojure.spec.alpha :as s]
    [codescene.features.api.spec.analysis :as analysis]
    [codescene.features.pm-data.specs :as pm-data]
    [codescene.specs :as specs]
    [spec-tools.data-spec :as ds]))

(s/def ::mapping (s/map-of ::specs/non-empty-string ::specs/non-empty-string))

;; the compojure swagger is quite incapable of correctly parsing multi-specs or or-specs,
;; so we make a really simple dumb one that unfortunately doesn't tell the user which properties
;; go with which provider
;; also API spec needs to have snake cased properties, so we need to handle this here
(def api-spec
  (s/spec (ds/spec {:spec {:type ::analysis/pm_provider_types
                           (ds/opt :api_url) ::pm-data/api-url
                           (ds/opt :organization) ::pm-data/organization
                           :name ::pm-data/name
                           (ds/opt :username) ::pm-data/username
                           :password ::pm-data/password
                           (ds/opt :cost_field) ::pm-data/cost-field
                           (ds/opt :external_project_ids) ::pm-data/external-project-ids
                           (ds/opt :work_in_progress_transition_names) ::pm-data/work-in-progress-transition-names
                           (ds/opt :work_done_transition_names) ::pm-data/work-done-transition-names
                           (ds/opt :supported_work_types) ::pm-data/supported-work-types
                           (ds/opt :defect_and_failure_labels) ::pm-data/defect-and-failure-labels
                           (ds/opt :rename_work_types) ::mapping
                           (ds/opt :project_aliases) ::mapping
                           (ds/opt :map_subtasks_to_parent_issues) ::pm-data/map-subtasks-to-parent-issues
                           (ds/opt :map_commits_to_pull_request_issues) ::pm-data/map-commits-to-pull-request-issues
                           (ds/opt :use_labels_as_work_types) ::pm-data/use-labels-as-work-types}
                    :name :pm-integration/spec})))

(def api-pr-spec
  (s/spec (ds/spec {:spec {:type ::analysis/pr_provider_types
                           (ds/opt :api_url) (s/nilable ::pm-data/api-url)
                           (ds/opt :username) (s/nilable ::pm-data/username)
                           (ds/opt :password) (s/nilable ::pm-data/password)}
                    :name :pr-provider/spec})))
