-- name: delete-all!
-- Deletes all existing code coverage data.
delete from code_coverage_data;

-- name: select-all
select * from code_coverage_data;

-- name: insert-code-coverage-data<!
-- Inserts the given code coverage metadata.
insert into code_coverage_data
    (created_at, repo, repo_path, subpath, commit_sha, format, metric)
values (:created_at, :repo, :repo_path, :subpath, :commit_sha, :format, :metric);

-- name: set-data-path!
-- Sets the data path for the given code coverage data.
update code_coverage_data
set data_path = :data_path
where id = :id;

-- name: delete-coverage-data-by-id!
-- Deletes the coverage data with the given id.
delete from code_coverage_data
where id = :id;

-- name: delete-coverage-data-by-repo!
-- Deletes the coverage data for the given repo.
delete from code_coverage_data
where repo = :repo;

-- name: coverage-data-by-id
-- Returns the coverage data with the given id.
select * from code_coverage_data
where id = :id;

-- name: coverage-data-by-repo
-- Returns the coverage data for the given repo.
select * from code_coverage_data
where repo = :repo;


