-- name: delete-transformation-by-project-id!
-- Deletes the transformation as identified by the id of its project.
DELETE FROM project_architectural_transformations
WHERE project_id = :project_id;

--name: delete-all-transformations!
DELETE FROM project_architectural_transformations;

--name: delete-transformations-by-ids!
DELETE FROM project_architectural_transformations
WHERE project_id = :project_id
AND id IN (:ids);

-- name: transformations-by-project-id
-- Returns all architectural transformations for the given project.
SELECT pattern, transformation, match_priority
FROM project_architectural_transformations
WHERE project_id = :project_id
ORDER BY match_priority, id ASC;


-- name: transformations-with-ids-by-project-id
-- Returns all architectural transformations for the given project,
-- including transformation and project ids
SELECT pattern, transformation, match_priority, project_id, id
FROM project_architectural_transformations
WHERE project_id = :project_id
ORDER BY match_priority, id ASC;


-- name: match-priorities-for-project-transformation
SELECT match_priority
FROM project_architectural_transformations
WHERE project_id = :project_id
      AND match_priority IS NOT NULL
      AND transformation = :transformation;


-- name: insert-transformation!
-- Inserts the transformation associated with the specified project.
INSERT INTO project_architectural_transformations (pattern, transformation, match_priority, project_id)
VALUES (:pattern, :transformation, :match_priority, :project_id);


-- name: update-transformation-by-id!
UPDATE project_architectural_transformations
SET pattern = :pattern, transformation = :transformation, match_priority = :match_priority
WHERE project_id = :project_id
AND id = :id;


