{% if improvements.files-improved > 0 %}{{ icons.pass }} Code Health Improved `({{ improvements.files-improved }} files improve in Code Health)`
{% endif %}
{% if qg-summary.fail|not-empty %}**Gates Failed**{% for item in qg-summary.fail %}
{{ icons.fail }} {{ item.gate-name }} `({{ item.desc|safe }})`{% endfor %}{% endif %}
{% if qg-summary.pass|not-empty %}
**Gates Passed**
{{ icons.pass }} {{ qg-summary.pass|length }} Quality Gates Passed{% endif %}{% if all qg-summary.pass|empty? qg-summary.fail|empty? %}
{% if qg-meta.empty-results? %}**No application code in the PR — skipped Code Health checks.**{% else %}**No quality gates enabled for this code.**{% endif %}{% endif %}

{% if result-url %}
[See analysis details in CodeScene]({{ result-url }}){% endif %}
{% if qg-summary.fail|not-empty %}<details><summary>Reason for failure</summary>

{% for item in qg-summary.fail %}{% ifequal item.gate "refactoring-goals" %}
| {{ item.gate-name }} |
|----------------------|
{% for cause in item.causes %}| {{ cause.file-name }} |
{% endfor %}
{% else %}| {{ item.gate-name }} | Violations | Code Health Impact |         |
|-|----|-|--|
{% for cause in item.causes %}| {{ cause.file-name }} | {% if cause.provider-url %}[{{ cause.violations }}]({{ cause.provider-url|safe }}){% else %}{{ cause.violations }}{% endif %} | {{ cause.code-health-impact }} | [Suppress]({{ cause.suppress-url|safe }}) |
{% endfor %}{% endifequal %}
{% endfor %}</details>{% endif %}
{% if improvements.files-improved > 0 %}<details><summary>View Improvements</summary>

| File | Code Health Impact | Categories Improved |
|-|----|--|
{% for f in improvements.files %}| {{ f.file-name }} | {{ f.code-health-impact }} | {{ f.categories }} |
{% endfor %}
</details>{% endif %}{% if code-owners-for-cc|not-empty %}
#### Code Owners for Critical Code
{% for code-owner in code-owners-for-cc %}* {{code-owner}}
{% endfor %}{% endif %}
{% if directives.added|not-empty %}
**Code Health Directives**
[{{directives.added|length}} new code health directive{% if not directives.added|length = 1 %}s{% endif %}]({{ result-url }}?added-directives=true){% endif %}
{% if result.absent-changes|not-empty %}**Absence of Expected Change Pattern**
{% for f1, files in result.absent-changes %}* {{f1}} is usually changed with: {{files|join:", "}}
{% endfor %}{% endif %}
##              
**Quality Gate Profile:** [{{ qg-meta.qg-profile-name }}]({{ qg-config-url|safe }})
[Install CodeScene MCP](https://codescene.io/docs/developer-tools/mcp/codescene-mcp-server.html): safeguard and uplift AI-generated code. Catch issues early with our [IDE extension](https://codescene.com/developer-hub) and [CLI tool]({{ doc-cli-page|safe }}).