-- :name insert-time-series-entry :insert :raw
INSERT INTO time_series_metrics
       (timestamp, time_series_type, time_series_json, project_id)
       VALUES
       (:timestamp, :time_series_type, :time_series_json, :project_id);

-- :name get-all-time-series-entries-for-project :? :*
SELECT time_series_json
       FROM time_series_metrics
       WHERE time_series_type = :time_series_type
             AND
             project_id = :project_id
        ORDER BY timestamp ASC;

-- :name get-all-time-series-entries-for-project-until :? :*
SELECT time_series_json
       FROM time_series_metrics
       WHERE time_series_type = :time_series_type
             AND
             project_id = :project_id
             AND
             timestamp <= :end_timestamp
      ORDER BY timestamp ASC;

-- :name get-all-time-series-entries-for-project-by-range :? :*
SELECT time_series_json
       FROM time_series_metrics
       WHERE time_series_type = :time_series_type
             AND
             project_id = :project_id
             AND
             timestamp <= :end_timestamp
             AND
             timestamp >= :start_timestamp
      ORDER BY timestamp ASC;

-- :name get-most-recent-time-series-entry-for-project :? :1
SELECT time_series_json
       FROM time_series_metrics
       WHERE time_series_type = :time_series_type
             AND
             project_id = :project_id
       ORDER BY timestamp DESC
       LIMIT 1;
