
drop table tag_hierarchy;
drop table tag_assignments;
drop table analytical_units;
drop table tags;

-- Create tables

create table tags (
  id int auto_increment,
  name varchar(200) not null,
  primary key (id)
);

create table analytical_units (
  id int auto_increment,
  name varchar(200) not null, 
  type varchar(200) not null,
  project_id int not null,
  primary key (id),
  unique (type, name, project_id)
);

create table tag_assignments (
  tag_id int not null references tag(id) on delete cascade,
  analytical_unit_id int not null references analytical_units(id) on delete cascade, 
  primary key (tag_id, analytical_unit_id)
);

create table tag_hierarchy (
  parent_tag_id  int not null references tag(tag_id) on delete cascade,
  child_tag_id   int not null references tag(tag_id) on delete cascade,
  primary key (parent_tag_id, child_tag_id)
 );

