(ns codescene.features.api.routes.event-tracking
  (:require
   [clojure.spec.alpha :as s]
   [codescene.features.api.core :as api-core]
   [codescene.features.api.spec.analysis :as api-analysis-spec]
   [codescene.features.components.analytics :as analytics]
   [codescene.features.components.auth :as auth]
   [codescene.features.util.api :as api-utils]
   [compojure.api.sweet :refer [POST context]]
   [spec-tools.data-spec :as ds]
   [spec-tools.spec :as spec]))

(defn- track
  [system request {:keys [event-type event-properties]}]
  (let [user (auth/user (api-core/api-auth system) request)
        analytics (api-core/api-analytics system)]
    (analytics/send-user-event analytics user (keyword event-type) event-properties)
    (api-utils/ok {:status "ok"})))

(defn sub-routes [system]
  (context "/analytics" []
    (POST "/track" req
      :body [data (ds/spec {:spec (s/keys :req-un [::api-analysis-spec/event-type ::api-analysis-spec/event-properties])})]
      :responses {200 {:schema spec/any?
                       :description "Track usage events."}}
      (track system req data))))