(ns codescene.features.api.routes.delta-analyses
  (:require [compojure.api.sweet :refer [routes GET context]]
            [spec-tools.spec :as spec]
            [codescene.features.api.privileges :as api-privileges]
            [codescene.features.api.core :as api-core]
            [codescene.features.api.spec.delta-analysis :as api-delta-analysis-spec]
            [codescene.features.api.delta-analyses :as delta-analysis]))

(defn- delta-analysis-sub-routes
  [system project-id]
  (routes
    (GET "/" []
      :tags ["delta-analyses"]
      :query-params [{page :- spec/pos-int? 1}
                     {filter :- spec/string? ""}]
      :responses {200 {:schema      ::api-delta-analysis-spec/delta_analyses_list
                       :description "delta analyses list for the given project id"}}
      (delta-analysis/list-result system project-id {:page page :filter-str filter}))
    (GET "/:delta-analysis-id" []
      :tags ["delta-analyses"]
      :responses {200 {:schema      ::api-delta-analysis-spec/delta_analysis
                       :description "delta analyses for the given id"}}
      :path-params [delta-analysis-id :- spec/pos-int?]
      (delta-analysis/delta-analysis-result system project-id delta-analysis-id))))

(defn sub-routes
  [system project-id]
  (context "/delta-analyses" []
    :middleware [#(api-core/wrap-authorize-project system % project-id #{api-privileges/restapi-read})]
    (delta-analysis-sub-routes system project-id)))
