(ns codescene.features.api.routes.analytical
  (:require [compojure.api.sweet :refer [routes GET POST PUT DELETE context]]
            [spec-tools.spec :as spec]
            [codescene.features.api.spec.common :as common-spec]
            [spec-tools.data-spec :as ds]
            [codescene.features.components.project :as project-component]
            [codescene.features.components.auth :as auth-component]
            [clojure.spec.alpha :as s]
            [codescene.features.api.privileges :as api-privileges]
            [codescene.features.api.core :as api-core]
            [codescene.features.api.spec.analysis :as api-analysis-spec]
            [codescene.features.api.spec.analytical :as api-analytical-spec]
            [codescene.features.api.analytical :as analytical]))


(defn tags-sub-routes
  [system]
  (routes
   (context "/tags" request
     (GET "/" []
       :summary "Analytical tags"
       :tags ["analytical"]
       :query-params [{page :- spec/int? 1}
                      {filter :- spec/string? ""}]
       :responses {200 {:schema spec/any?
                        :description "project list for the authenticated user"}}
       (analytical/analytical-tags system request {:page page
                                                   :filter-str filter}))
     (POST "/" []
       :summary "Create new tag"
       :tags ["analytical"]
       :body [data (ds/spec {:spec (s/keys :req-un [::common-spec/name])
                             :name :tag})]
       :responses {201 {:schema      spec/any?
                        :description "the tag json data"}}
       (analytical/add-tag system request data))
     (DELETE "/:tag_id" [tag_id]
       :path-params [tag_id :- spec/pos-int?]
       :summary "Delete a team"
       :tags ["teams and developers"]
       :responses {200 {:schema      spec/any?
                        :description "delete the tag with the given id"}}
       (analytical/delete-tag system request tag_id)))))


(defn- units-sub-routes
  [system]
  (routes
   (context "/units" request
     (GET "/" []
       :summary "Analytical units"
       :tags ["analytical"]
       :query-params [{page :- spec/int? 1}
                      {filter :- spec/string? ""}]
       :responses {200 {:schema spec/any?
                        :description "list of analytical units"}}
       (analytical/analytical-units system request {:page page
                                                   :filter-str filter}))
     (POST "/with-tags" []
       :summary "Analytical units"
       :tags ["analytical"]
       :query-params [{page :- spec/int? 1}
                      {filter :- spec/string? ""}]
       :body [data (ds/spec {:spec (s/keys :req-un [::api-analytical-spec/types
                                                    ::api-analytical-spec/tag-ids]) 
                             :name :query-params})]
       :responses {200 {:schema spec/any?
                        :description "list of analytical units of specified types with specified tags"}}
       (analytical/analytical-units-with-tags system request data {:page page
                                                                   :filter-str filter})))))
(defn- assignments-sub-routes
  [system]
  (routes
   (context "/assignments" request
     (GET "/" []
       :summary "Tag Assignments"
       :tags ["analytical"]
       :query-params [{page :- spec/int? 1}
                      {filter :- spec/string? ""}]
       :responses {200 {:schema spec/any?
                        :description "assignment list for the specified tag"}}
       (analytical/tag-assignments system request {:page page
                                                   :filter-str filter}))
     (POST "/" []
       :summary "Assign a tag"
       :tags ["analytical"]
       :body [data (ds/spec {:spec (s/keys :req-un [::api-analytical-spec/tag-id
                                                    ::api-analytical-spec/analytical-unit-id])
                             :name :assignment})]
       :responses {201 {:schema      spec/any?
                        :description "the tag json data"}}
       (analytical/assign-tag system request data))
     (DELETE "/" []
       :summary "Unassign a tag"
       :tags ["analytical"]
       :body [data (ds/spec {:spec (s/keys :req-un [::api-analytical-spec/tag-id
                                                    ::api-analytical-spec/analytical-unit-id])
                             :name :assignment})]
       :responses {200 {:schema      spec/any?
                        :description "delete the tag with the given id"}}
       (analytical/unassign-tag system request data)))))
(defn sub-routes
  [system]
  (routes
   (context "/analytical" []
     (tags-sub-routes system)
     (units-sub-routes system)
     (assignments-sub-routes system))))
