

-- :name select-all-analytical-unit-types :?  :*
select id, type_name from analytical_unit_types;

-- :name select-all-metric-types :? :*
select id, metric_name from metrics;

-- :name select-analytical-unit-by-id :? :1
select * 
from analytical_units
where
    id = :id
    
-- :name select-analytical-units-by-project-id-and-type :?  :*
select *
from analytical_units
where
    project_id = :project_id
    and analytical_unit_type_id = :unit_type_id;

-- :name select-analytical-unit-by-name-and-type :? :n
select * from analytical_units
where
        project_id = :project_id
        and account_id = :account_id
        and analytical_unit_type_id = :unit_type_id
        and name = :name;


-- :name set-to-deleted! :! :n
update analytical_units
set deleted_at = CURRENT_TIMESTAMP
where id = :id;

-- :name set-to-not-deleted! :! :n
update analytical_units
set deleted_at = null
where id = :id;

-- :name insert-analytical-unit :insert :raw
insert into analytical_units
(account_id, project_id, parent_id, analytical_unit_type_id, name)
values
(:account_id, :project_id, :parent_id, :unit_type_id, :name);


-- :name insert-observation! :insert
insert into observations
(analytical_unit_id, metric_id, `value`)
values
(:analytical_unit_id, :metric_id, :value);


-- :name select-observations-for-analytical-unit :? :*
select o.*, m.metric_name from observations o
join analytical_units au on o.analytical_unit_id = au.id
join metrics m on o.metric_id = m.id
where o.analytical_unit_id = :analytical_unit_id and au.account_id = :account_id;

