// @flow
import $ from 'jquery';

import {autoGrowInputList} from '../../input-list';
import {validateRepoPathsOnServer} from '../repo-paths';

function anyInputHasValue(inputs : $) {
  return inputs.filter((i, e) => $(e).val() !== '' ).length > 0;
}

export function init() {
  const container = $('.project-wizard-view.specify-remotes');
  const inputList = container.find('#dynamic-vcs-list');
  const form = container.find('form');
  const text = form.find('.text');
  const progressIndicator = container.find('.clone-progress-indicator');

  autoGrowInputList(inputList, {
    prefix: 'vcs_',
    placeholder: 'ssh://[user@]host.xz[:port]/path/to/repo.git/',
    inputFieldCss: 'repo-path-input',
    siblings: [
      $('<div>', {'class': 'repo-path-alert'})
    ],
    onBlur: () => validateRepoPathsOnServer()
  });

  form.on('submit', () => {
    if (anyInputHasValue(inputList.find('input'))) {
      progressIndicator
        .removeClass('fa-search')
        .addClass('fa-circle-o-notch')
        .addClass('spinning');
      text.text('Cloning');
    }
  });

  // make sure that any repo path warnings (conflicting repo names) are immediatelly visible to the user.
  // this is useful when form with invalid repo paths is submitted and errors are reported to the user
  validateRepoPathsOnServer();
}
