// @flow
import d3 from 'd3';

export function drawRollingRiskFor(riskDataUrl : string, domDestination : string, areaStyleClass : string) {
  var margin = {top: 30, right: 20, bottom: 100, left: 120},
    margin2 = {top: 430, right: 20, bottom: 30, left: 120},
    width = 1000 - margin.left - margin.right,
    height = 500 - margin.top - margin.bottom,
    height2 = 500 - margin2.top - margin2.bottom;

  var parseDate = d3.time.format.iso.parse;

  var x = d3.time.scale().range([0, width]),
    x2 = d3.time.scale().range([0, width]),
    y = d3.scale.linear().range([height, 0]),
    y2 = d3.scale.linear().range([height2, 0]);

  var xAxis = d3.svg.axis().scale(x).orient('bottom'),
    xAxis2 = d3.svg.axis().scale(x2).orient('bottom'),
    yAxis = d3.svg.axis().scale(y).orient('left');

  var brush = d3.svg.brush()
    .x(x2)
    .on('brush', brushed);

  var area = d3.svg.area()
    .interpolate('basis')
    .x(function(d) { return x(d.date); })
    .y0(height)
    .y1(function(d) { return y(d.rollingrisk); });

  var area2 = d3.svg.area()
    .interpolate('basis')
    .x(function(d) { return x2(d.date); })
    .y0(height2)
    .y1(function(d) { return y2(d.rollingrisk); });

  var fullWidth = width + margin.left + margin.right;
  var fullHeight = height + margin.top + margin.bottom;
  var svg = d3.select(domDestination).append('svg')
    .attr('preserveAspectRatio', 'xMidYMid meet')
    .attr('viewBox', '0 0 ' + fullWidth + ' ' + fullHeight)
    .attr('width', fullWidth)
    .attr('height', fullHeight)
    .style('font-size', '12px');

  svg.append('defs').append('clipPath')
    .attr('id', 'clip')
    .append('rect')
    .attr('width', width)
    .attr('height', height);

  var focus = svg.append('g')
    .attr('class', 'focus')
    .attr('transform', 'translate(' + margin.left + ',' + margin.top + ')');

  var context = svg.append('g')
    .attr('class', 'context')
    .attr('transform', 'translate(' + margin2.left + ',' + margin2.top + ')');

  d3.csv(riskDataUrl, type, function(error, data) {
    x.domain(d3.extent(data.map(function(d) { return d.date; })));

    y.domain([0, d3.max(data, function(d) { return d.rollingrisk;})]);
    x2.domain(x.domain());
    y2.domain(y.domain());

    focus.append('path')
      .datum(data)
      .attr('class', areaStyleClass)
      .attr('d', area);

    focus.append('g')
      .attr('class', 'x axis')
      .attr('transform', 'translate(0,' + height + ')')
      .call(xAxis);

    focus.append('g')
      .attr('class', 'y axis')
      .call(yAxis)
      .append('text')
      .attr('y', -10)
      .style('font-size', '15px')
      .style('text-anchor', 'middle')
      .text('Risk (1-10)');

    context.append('path')
      .datum(data)
      .attr('class', areaStyleClass)
      .attr('d', area2);

    context.append('g')
      .attr('class', 'x axis')
      .attr('transform', 'translate(0,' + height2 + ')')
      .call(xAxis2);

    context.append('g')
      .attr('class', 'x brush')
      .call(brush)
      .selectAll('rect')
      .attr('y', -6)
      .attr('height', height2 + 7);
  });

  function brushed() {
    x.domain(brush.empty() ? x2.domain() : brush.extent());
    focus.select('.' + areaStyleClass).attr('d', area);
    focus.select('.x.axis').call(xAxis);
  }

  function type(d) {
    d.date = parseDate(d.date);
    d.rollingrisk = +d.rollingrisk;
    return d;
  }
}
